/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.service.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GetFeaturesResponse {
    private final List<Result> results;

    private GetFeaturesResponse(Builder builder) {
        this.results = builder.results;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Result {
        private final Status status;
        private final Map<String, Object> entityKeys;
        private final Map<String, Object> features;
        private final String error;

        private Result(Builder builder) {
            this.status = builder.status;
            this.entityKeys = builder.entityKeys;
            this.features = builder.features;
            this.error = builder.error;
        }

        public Status getStatus() {
            return this.status;
        }

        public Map<String, Object> getFeatures() {
            return this.features;
        }

        public Map<String, Object> getEntityKeys() {
            return this.entityKeys;
        }

        public String getError() {
            return this.error;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Status status;
            private Map<String, Object> entityKeys;
            private Map<String, Object> features;
            private String error;

            public Builder status(Status status) {
                this.status = status;
                return this;
            }

            public Builder features(Map<String, Object> map) {
                this.features = map;
                return this;
            }

            public Builder entityKeys(Map<String, Object> map) {
                this.entityKeys = map;
                return this;
            }

            public Builder error(String string) {
                this.error = string;
                return this;
            }

            public Result build() {
                return new Result(this);
            }
        }

        public static enum Status {
            Success,
            Failure;

        }
    }

    public static class Builder {
        private List<Result> results = new ArrayList<Result>();

        public Builder results(List<Result> list) {
            this.results = list;
            return this;
        }

        public Builder addResult(Result result) {
            this.results.add(result);
            return this;
        }

        public GetFeaturesResponse build() {
            return new GetFeaturesResponse(this);
        }
    }
}

