/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.service;

import ai.chronon.online.Api;
import ai.chronon.service.ConfigStore;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.util.ScalaVersionSpecificCollectionsConverter;

public class ApiProvider {
    private static final Logger logger = LoggerFactory.getLogger(ApiProvider.class);

    public static Api buildApi(ConfigStore configStore) throws Exception {
        Optional<String> optional = configStore.getOnlineJar();
        Optional<String> optional2 = configStore.getOnlineClass();
        if (!optional.isPresent() || !optional2.isPresent()) {
            throw new IllegalArgumentException("Both 'online.jar' and 'online.class' configs must be set.");
        }
        String string = optional.get();
        String string2 = optional2.get();
        File file = new File(string);
        if (!file.exists()) {
            throw new IllegalArgumentException("JAR file does not exist: " + string);
        }
        logger.info("Loading API implementation from JAR: {}, class: {}", (Object)string, (Object)string2);
        URL uRL = file.toURI().toURL();
        URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, ApiProvider.class.getClassLoader());
        Class<?> clazz = Class.forName(string2, true, uRLClassLoader);
        if (!Api.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + string2 + " does not extend the Api abstract class");
        }
        Map<String, String> map = configStore.getOnlineApiProps();
        scala.collection.immutable.Map map2 = ScalaVersionSpecificCollectionsConverter.convertJavaMapToScala(map);
        return (Api)clazz.getConstructors()[0].newInstance(map2);
    }
}

