/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.service;

import ai.chronon.online.Api;
import ai.chronon.service.ApiProvider;
import ai.chronon.service.ConfigStore;
import ai.chronon.service.handlers.FeaturesRouter;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceVerticle
extends AbstractVerticle {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceVerticle.class);
    private HttpServer server;

    public void start(Promise<Void> promise) throws Exception {
        ConfigStore configStore = new ConfigStore(this.vertx);
        this.startHttpServer(configStore.getServerPort(), configStore.encodeConfig(), ApiProvider.buildApi(configStore), promise);
    }

    protected void startHttpServer(int n, String string, Api api, Promise<Void> promise) throws Exception {
        Router router = Router.router((Vertx)this.vertx);
        router.route("/v1/features/*").subRouter(FeaturesRouter.createFeaturesRoutes(this.vertx, api));
        router.get("/ping").handler(routingContext -> routingContext.json((Object)"Pong!"));
        router.get("/config").handler(routingContext -> routingContext.response().putHeader("content-type", "application/json").end(string));
        HttpServerOptions httpServerOptions = new HttpServerOptions().setTcpKeepAlive(true).setIdleTimeout(60);
        this.server = this.vertx.createHttpServer(httpServerOptions);
        this.server.requestHandler((Handler)router).listen(n).onSuccess(httpServer -> {
            logger.info("HTTP server started on port {}", (Object)httpServer.actualPort());
            promise.complete();
        }).onFailure(throwable -> {
            logger.error("Failed to start HTTP server", throwable);
            promise.fail(throwable);
        });
    }

    public void stop(Promise<Void> promise) {
        logger.info("Stopping HTTP server...");
        if (this.server != null) {
            this.server.close().onSuccess(void_ -> {
                logger.info("HTTP server stopped successfully");
                promise.complete();
            }).onFailure(throwable -> {
                logger.error("Failed to stop HTTP server", throwable);
                promise.fail(throwable);
            });
        } else {
            promise.complete();
        }
    }
}

