/*
 * Decompiled with CFR 0.152.
 */
package ai.chronon.service.handlers;

import ai.chronon.online.JTry;
import ai.chronon.online.JavaFetcher;
import ai.chronon.online.JavaRequest;
import ai.chronon.online.JavaResponse;
import ai.chronon.service.model.GetFeaturesResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RequestBody;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesHandler
implements Handler<RoutingContext> {
    private static final Logger logger = LoggerFactory.getLogger(FeaturesHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final EntityType entityType;
    private final JavaFetcher fetcher;

    public FeaturesHandler(EntityType entityType, JavaFetcher javaFetcher) {
        this.entityType = entityType;
        this.fetcher = javaFetcher;
    }

    public void handle(RoutingContext routingContext) {
        String string = routingContext.pathParam("name");
        logger.debug("Retrieving {} - {}", (Object)this.entityType.name(), (Object)string);
        JTry<List<JavaRequest>> jTry = FeaturesHandler.parseJavaRequest(string, routingContext.body());
        if (!jTry.isSuccess()) {
            logger.error("Unable to parse request body", jTry.getException());
            List<String> list2 = Collections.singletonList(jTry.getException().getMessage());
            routingContext.response().setStatusCode(400).putHeader("content-type", "application/json").end(new JsonObject().put("errors", list2).encode());
            return;
        }
        List list3 = (List)jTry.getValue();
        CompletableFuture completableFuture = this.entityType.equals((Object)EntityType.GroupBy) ? this.fetcher.fetchGroupBys(list3) : this.fetcher.fetchJoin(list3);
        Future future = Future.fromCompletionStage((CompletionStage)completableFuture).map(list -> list.stream().map(FeaturesHandler::responseToPoJo).collect(Collectors.toList()));
        future.onSuccess(list -> {
            GetFeaturesResponse.Builder builder = GetFeaturesResponse.builder();
            List<GetFeaturesResponse.Result> list2 = list.stream().map(entityKeyToValues -> {
                if (entityKeyToValues.features.isSuccess()) {
                    return GetFeaturesResponse.Result.builder().status(GetFeaturesResponse.Result.Status.Success).entityKeys(entityKeyToValues.entityKeys).features((Map)entityKeyToValues.features.getValue()).build();
                }
                return GetFeaturesResponse.Result.builder().status(GetFeaturesResponse.Result.Status.Failure).entityKeys(entityKeyToValues.entityKeys).error(entityKeyToValues.features.getException().getMessage()).build();
            }).collect(Collectors.toList());
            builder.results(list2);
            routingContext.response().setStatusCode(200).putHeader("content-type", "application/json").end(JsonObject.mapFrom((Object)builder.build()).encode());
        });
        future.onFailure(throwable -> {
            List<String> list = Collections.singletonList(throwable.getMessage());
            routingContext.response().setStatusCode(500).putHeader("content-type", "application/json").end(new JsonObject().put("errors", list).encode());
        });
    }

    public static EntityKeyToValues responseToPoJo(JavaResponse javaResponse) {
        return new EntityKeyToValues(javaResponse.request.keys, (JTry<Map<String, Object>>)javaResponse.values);
    }

    public static JTry<List<JavaRequest>> parseJavaRequest(String string, RequestBody requestBody) {
        TypeReference<List<Map<String, Object>>> typeReference = new TypeReference<List<Map<String, Object>>>(){};
        try {
            List list = (List)objectMapper.readValue(requestBody.asString(), (TypeReference)typeReference);
            List list2 = list.stream().map(map -> new JavaRequest(string, map)).collect(Collectors.toList());
            return JTry.success(list2);
        }
        catch (Exception exception) {
            return JTry.failure((Throwable)exception);
        }
    }

    private static class EntityKeyToValues {
        public Map<String, Object> entityKeys;
        public JTry<Map<String, Object>> features;

        public EntityKeyToValues(Map<String, Object> map, JTry<Map<String, Object>> jTry) {
            this.entityKeys = map;
            this.features = jTry;
        }
    }

    public static enum EntityType {
        GroupBy,
        Join;

    }
}

