/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.agent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;

public class ActiveJobTransformer
implements ClassFileTransformer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (!"org/apache/spark/scheduler/ActiveJob".equalsIgnoreCase(className)) {
            return classfileBuffer;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(classfileBuffer);){
            System.out.printf("Instrumenting class %s%n", className);
            ClassPool cp = ClassPool.getDefault();
            cp.appendClassPath((ClassPath)new LoaderClassPath(loader));
            CtClass ct = cp.makeClass((InputStream)is);
            for (CtConstructor constructor : ct.getConstructors()) {
                if (!constructor.callsSuper()) continue;
                constructor.insertAfter("{ ai.databand.spark.ActiveJobTracker.track(this); }");
            }
            byte[] byArray = ct.toBytecode();
            return byArray;
        }
        catch (Throwable e) {
            System.err.println("Class instrumentation failed");
            e.printStackTrace();
            return null;
        }
    }
}

