/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.config;

import ai.databand.config.NormalizedProps;
import ai.databand.config.PropertiesSource;
import ai.databand.config.SimpleProps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SparkConf
implements PropertiesSource {
    private final Map<String, String> props;

    public SparkConf(String command) {
        this(new SimpleProps(), command);
    }

    public SparkConf(PropertiesSource parent) {
        this(parent, System.getProperties().getProperty("sun.java.command"));
    }

    public SparkConf(PropertiesSource parent, String command) {
        this.props = new HashMap<String, String>(parent.values());
        HashMap<String, String> sparkProps = new HashMap<String, String>();
        for (String next : command.split(" ")) {
            String[] keyValue;
            if (!next.startsWith("spark.env.") || !next.contains("=") || (keyValue = next.split("=")).length != 2) continue;
            sparkProps.put(keyValue[0].replace("spark.env.", ""), keyValue[1]);
        }
        this.props.putAll(new NormalizedProps(sparkProps).values());
    }

    @Override
    public Map<String, String> values() {
        return Collections.unmodifiableMap(this.props);
    }

    @Override
    public Optional<String> getValue(String key) {
        return Optional.ofNullable(this.props.get(key));
    }
}

