/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.IOException;
import java.net.ProtocolException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Connection;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.NamedRunnable;
import okhttp3.internal.Platform;
import okhttp3.internal.http.HttpEngine;
import okhttp3.internal.http.RequestException;
import okhttp3.internal.http.RouteException;
import okhttp3.internal.http.StreamAllocation;

final class RealCall
implements Call {
    private final OkHttpClient client;
    private boolean executed;
    volatile boolean canceled;
    Request originalRequest;
    HttpEngine engine;

    protected RealCall(OkHttpClient client, Request originalRequest) {
        this.client = client;
        this.originalRequest = originalRequest;
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() throws IOException {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        try {
            this.client.dispatcher().executed(this);
            Response result = this.getResponseWithInterceptorChain(false);
            if (result == null) {
                throw new IOException("Canceled");
            }
            Response response = result;
            return response;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    Object tag() {
        return this.originalRequest.tag();
    }

    @Override
    public void enqueue(Callback responseCallback) {
        this.enqueue(responseCallback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Callback responseCallback, boolean forWebSocket) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.client.dispatcher().enqueue(new AsyncCall(responseCallback, forWebSocket));
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.engine != null) {
            this.engine.cancel();
        }
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    private String toLoggableString() {
        String string = this.canceled ? "canceled call" : "call";
        return string + " to " + this.redactedUrl();
    }

    HttpUrl redactedUrl() {
        return this.originalRequest.url().resolve("/...");
    }

    private Response getResponseWithInterceptorChain(boolean forWebSocket) throws IOException {
        ApplicationInterceptorChain chain = new ApplicationInterceptorChain(0, this.originalRequest, forWebSocket);
        return chain.proceed(this.originalRequest);
    }

    Response getResponse(Request request, boolean forWebSocket) throws IOException {
        RequestBody body = request.body();
        if (body != null) {
            long contentLength;
            Request.Builder requestBuilder = request.newBuilder();
            MediaType contentType = body.contentType();
            if (contentType != null) {
                requestBuilder.header("Content-Type", contentType.toString());
            }
            if ((contentLength = body.contentLength()) != -1L) {
                requestBuilder.header("Content-Length", Long.toString(contentLength));
                requestBuilder.removeHeader("Transfer-Encoding");
            } else {
                requestBuilder.header("Transfer-Encoding", "chunked");
                requestBuilder.removeHeader("Content-Length");
            }
            request = requestBuilder.build();
        }
        this.engine = new HttpEngine(this.client, request, false, false, forWebSocket, null, null, null);
        int followUpCount = 0;
        while (true) {
            StreamAllocation streamAllocation;
            HttpEngine retryEngine;
            if (this.canceled) {
                this.engine.releaseStreamAllocation();
                throw new IOException("Canceled");
            }
            boolean releaseConnection = true;
            try {
                this.engine.sendRequest();
                this.engine.readResponse();
                releaseConnection = false;
            }
            catch (RequestException e) {
                throw e.getCause();
            }
            catch (RouteException e) {
                retryEngine = this.engine.recover(e.getLastConnectException(), true, null);
                if (retryEngine != null) {
                    releaseConnection = false;
                    this.engine = retryEngine;
                    continue;
                }
                throw e.getLastConnectException();
            }
            catch (IOException e) {
                retryEngine = this.engine.recover(e, false, null);
                if (retryEngine != null) {
                    releaseConnection = false;
                    this.engine = retryEngine;
                    continue;
                }
                throw e;
            }
            finally {
                if (!releaseConnection) continue;
                streamAllocation = this.engine.close();
                streamAllocation.release();
                continue;
            }
            Response response = this.engine.getResponse();
            Request followUp = this.engine.followUpRequest();
            if (followUp == null) {
                if (!forWebSocket) {
                    this.engine.releaseStreamAllocation();
                }
                return response;
            }
            streamAllocation = this.engine.close();
            if (++followUpCount > 20) {
                streamAllocation.release();
                throw new ProtocolException("Too many follow-up requests: " + followUpCount);
            }
            if (!this.engine.sameConnection(followUp.url())) {
                streamAllocation.release();
                streamAllocation = null;
            } else if (streamAllocation.stream() != null) {
                throw new IllegalStateException("Closing the body of " + response + " didn't close its backing stream. Bad interceptor?");
            }
            request = followUp;
            this.engine = new HttpEngine(this.client, request, false, false, forWebSocket, streamAllocation, null, response);
        }
    }

    class ApplicationInterceptorChain
    implements Interceptor.Chain {
        private final int index;
        private final Request request;
        private final boolean forWebSocket;

        ApplicationInterceptorChain(int index, Request request, boolean forWebSocket) {
            this.index = index;
            this.request = request;
            this.forWebSocket = forWebSocket;
        }

        @Override
        public Connection connection() {
            return null;
        }

        @Override
        public Request request() {
            return this.request;
        }

        @Override
        public Response proceed(Request request) throws IOException {
            if (this.index < RealCall.this.client.interceptors().size()) {
                ApplicationInterceptorChain chain = new ApplicationInterceptorChain(this.index + 1, request, this.forWebSocket);
                Interceptor interceptor = RealCall.this.client.interceptors().get(this.index);
                Response interceptedResponse = interceptor.intercept(chain);
                if (interceptedResponse == null) {
                    throw new NullPointerException("application interceptor " + interceptor + " returned null");
                }
                return interceptedResponse;
            }
            return RealCall.this.getResponse(request, this.forWebSocket);
        }
    }

    final class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;
        private final boolean forWebSocket;

        private AsyncCall(Callback responseCallback, boolean forWebSocket) {
            super("OkHttp %s", RealCall.this.redactedUrl().toString());
            this.responseCallback = responseCallback;
            this.forWebSocket = forWebSocket;
        }

        String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }

        Object tag() {
            return RealCall.this.originalRequest.tag();
        }

        void cancel() {
            RealCall.this.cancel();
        }

        RealCall get() {
            return RealCall.this;
        }

        @Override
        protected void execute() {
            boolean signalledCallback = false;
            try {
                Response response = RealCall.this.getResponseWithInterceptorChain(this.forWebSocket);
                if (RealCall.this.canceled) {
                    signalledCallback = true;
                    this.responseCallback.onFailure(RealCall.this, new IOException("Canceled"));
                } else {
                    signalledCallback = true;
                    this.responseCallback.onResponse(RealCall.this, response);
                }
            }
            catch (IOException e) {
                if (signalledCallback) {
                    Platform.get().log(4, "Callback failure for " + RealCall.this.toLoggableString(), e);
                } else {
                    this.responseCallback.onFailure(RealCall.this, e);
                }
            }
            finally {
                RealCall.this.client.dispatcher().finished(this);
            }
        }
    }
}

