/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.log;

import ai.databand.DbndWrapper;
import ai.databand.log.HistogramRequest;
import ai.databand.schema.DatasetOperationStatus;
import ai.databand.schema.DatasetOperationType;
import org.apache.spark.sql.Dataset;

public class DbndLogger {
    public static void logMetric(String key, Object value) {
        try {
            DbndWrapper.instance().logMetric(key, value);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log metric");
            e.printStackTrace();
        }
    }

    public static void logDataframe(String key, Object value, boolean withHistograms) {
        try {
            DbndWrapper.instance().logDataframe(key, (Dataset)value, withHistograms);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataframe");
            e.printStackTrace();
        }
    }

    public static void logDataframe(String key, Object value, HistogramRequest histogramRequest) {
        try {
            DbndWrapper.instance().logDataframe(key, (Dataset)value, histogramRequest);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataframe");
            e.printStackTrace();
        }
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, Dataset<?> data) {
        DbndLogger.logDatasetOperation(path, type, DatasetOperationStatus.OK, data, true, true);
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data) {
        DbndLogger.logDatasetOperation(path, type, status, data, true, true);
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, Throwable error) {
        try {
            DbndWrapper.instance().logDatasetOperation(path, type, status, data, error, true, true, null);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataset operation");
            e.printStackTrace();
        }
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, Throwable error, boolean withPartition) {
        try {
            DbndWrapper.instance().logDatasetOperation(path, type, status, data, error, true, true, withPartition);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataset operation");
            e.printStackTrace();
        }
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, boolean withPreview) {
        DbndLogger.logDatasetOperation(path, type, status, data, withPreview, true, null);
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, boolean withPreview, boolean withSchema) {
        DbndLogger.logDatasetOperation(path, type, status, data, withPreview, withSchema, null);
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, boolean withPreview, boolean withSchema, Boolean withPartition) {
        try {
            DbndWrapper.instance().logDatasetOperation(path, type, status, data, withPreview, withSchema, withPartition);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataset operation");
            e.printStackTrace();
        }
    }
}

