/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.schema;

import ai.databand.schema.DatasetOperationStatus;
import ai.databand.schema.DatasetOperationType;
import ai.databand.schema.TaskRun;
import java.util.List;

public class LogDataset {
    private final String runUid;
    private final String taskRunUid;
    private final String taskRunName;
    private final String taskRunAttemptUid;
    private final String operationPath;
    private final String operationType;
    private final String operationStatus;
    private final String operationError;
    private final String valuePreview;
    private final List<Long> dataDimensions;
    private final Object dataSchema;
    private final Boolean withPartition;

    public LogDataset(TaskRun taskRun, String operationPath, DatasetOperationType operationType, DatasetOperationStatus operationStatus, String operationError, String valuePreview, List<Long> dataDimensions, Object dataSchema, Boolean withPartition) {
        this(taskRun.getRunUid(), taskRun.getTaskRunUid(), taskRun.getName(), taskRun.getTaskRunAttemptUid(), operationPath, operationType, operationStatus, operationError, valuePreview, dataDimensions, dataSchema, withPartition);
    }

    public LogDataset(String runUid, String taskRunUid, String taskRunName, String taskRunAttemptUid, String operationPath, DatasetOperationType operationType, DatasetOperationStatus operationStatus, String operationError, String valuePreview, List<Long> dataDimensions, Object dataSchema, Boolean withPartition) {
        this.runUid = runUid;
        this.taskRunUid = taskRunUid;
        this.taskRunName = taskRunName;
        this.taskRunAttemptUid = taskRunAttemptUid;
        this.operationPath = operationPath;
        this.operationType = operationType.toString();
        this.operationStatus = operationStatus.toString();
        this.operationError = operationError;
        this.valuePreview = valuePreview;
        this.dataDimensions = dataDimensions;
        this.dataSchema = dataSchema;
        this.withPartition = withPartition;
    }

    public String getRunUid() {
        return this.runUid;
    }

    public String getTaskRunUid() {
        return this.taskRunUid;
    }

    public String getTaskRunName() {
        return this.taskRunName;
    }

    public String getTaskRunAttemptUid() {
        return this.taskRunAttemptUid;
    }

    public String getOperationPath() {
        return this.operationPath;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public String getOperationStatus() {
        return this.operationStatus;
    }

    public String getOperationError() {
        return this.operationError;
    }

    public String getValuePreview() {
        return this.valuePreview;
    }

    public List<Long> getDataDimensions() {
        return this.dataDimensions;
    }

    public Object getDataSchema() {
        return this.dataSchema;
    }

    public Boolean getWithPartition() {
        return this.withPartition;
    }

    public String toString() {
        if (this.operationPath == null || this.operationType == null) {
            return "{empty operation}";
        }
        return String.format("{path: [%s], type: [%s], status: [%s]}", this.operationPath, this.operationType, this.operationStatus);
    }
}

