/*
 * Decompiled with CFR 0.152.
 */
package ai.databand;

import ai.databand.DbndApi;
import ai.databand.DbndApiBuilder;
import ai.databand.config.DbndConfig;
import ai.databand.id.Uuid5;
import ai.databand.schema.AddTaskRuns;
import ai.databand.schema.AirflowTaskContext;
import ai.databand.schema.ErrorInfo;
import ai.databand.schema.InitRun;
import ai.databand.schema.InitRunArgs;
import ai.databand.schema.LogDataset;
import ai.databand.schema.LogDatasets;
import ai.databand.schema.LogMetric;
import ai.databand.schema.LogMetrics;
import ai.databand.schema.LogTarget;
import ai.databand.schema.LogTargets;
import ai.databand.schema.Metric;
import ai.databand.schema.NewRunInfo;
import ai.databand.schema.RootRun;
import ai.databand.schema.SaveExternalLinks;
import ai.databand.schema.SaveTaskRunLog;
import ai.databand.schema.SetRunState;
import ai.databand.schema.TaskDefinition;
import ai.databand.schema.TaskRun;
import ai.databand.schema.TaskRunAttemptUpdate;
import ai.databand.schema.TaskRunEnv;
import ai.databand.schema.TaskRunsInfo;
import ai.databand.schema.TrackingSource;
import ai.databand.schema.UpdateTaskRunAttempts;
import java.io.IOException;
import java.net.ConnectException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class DbndClient {
    private static final Logger LOG = LoggerFactory.getLogger(DbndClient.class);
    private final DbndApi dbnd;
    private final DbndConfig config;
    private static final int MAX_METRICS_TO_DISPLAY = 10;

    public DbndClient(DbndConfig dbndConfig) {
        this.config = dbndConfig;
        this.dbnd = new DbndApiBuilder(dbndConfig).build();
    }

    public String initRun(String jobName, String runId, String user, String runName, TaskRunsInfo taskRunsInfo, AirflowTaskContext airflowTaskContext, RootRun root) {
        return this.initRun(jobName, runId, user, runName, taskRunsInfo, airflowTaskContext, root, null, null, null);
    }

    public String initRun(String jobName, String runId, String user, String runName, TaskRunsInfo taskRunsInfo, AirflowTaskContext airflowTaskContext, RootRun root, String source, TrackingSource trackingSource, String projectName) {
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        String runUid = new Uuid5("RUN_UID", runId).toString();
        String driverTaskUid = new Uuid5("DRIVER_TASK", runId).toString();
        String taskRunEnvUid = new Uuid5("TASK_RUN_ENV_UID", runId).toString();
        String userCodeVersion = new Uuid5("USER_CODE_VERSION", runId).toString();
        String machine = "";
        String databandVersion = "";
        String env = "local";
        String cloudType = "local";
        RootRun rootRun = root == null ? new RootRun("", null, runUid, null) : root;
        InitRun data = new InitRun(new InitRunArgs(runUid, rootRun.getRootRunUid(), driverTaskUid, new NewRunInfo(null, env, null, "jvm", now, now, false, "jvm", false, runUid, cloudType, "", runUid, jobName, user, null, runName, "RUNNING", now, rootRun, projectName), new TaskRunEnv("None", taskRunEnvUid, user, userCodeVersion, machine, "", now, databandVersion, "/", true), taskRunsInfo, airflowTaskContext, source, trackingSource));
        Call<Void> call = this.dbnd.initRun(data);
        Optional<Object> res = this.safeExecuteVoid(call, true);
        if (res.isPresent()) {
            LOG.info("[root_run_uid: {}, job_name: {}, run_name: {}] run created", new Object[]{runUid, jobName, runName});
            return runUid;
        }
        LOG.error("[root_run_uid: {}, job_name: {}, run_name: {}] init_run HTTP request to tracker failed", new Object[]{runUid, jobName, runName});
        throw new RuntimeException("Unable to init run because HTTP request to tracker failed");
    }

    public TaskRunsInfo addTaskRuns(String rootRunUid, String runId, List<TaskRun> taskRuns, List<TaskDefinition> taskDefinitions, List<List<String>> parentChildMap, List<List<String>> upstreamsMap) {
        String taskRunEnvUid = new Uuid5("TASK_RUN_ENV_UID", runId).toString();
        TaskRunsInfo taskRunsInfo = new TaskRunsInfo(taskRunEnvUid, parentChildMap, rootRunUid, taskRuns, Collections.emptyList(), rootRunUid, upstreamsMap, true, taskDefinitions, null);
        Call<Void> call = this.dbnd.addTaskRuns(new AddTaskRuns(taskRunsInfo));
        Optional<Object> res = this.safeExecuteVoid(call);
        if (res.isPresent()) {
            for (TaskRun task : taskRuns) {
                LOG.info("[task_run_uid: {}, task_name: {}] task created", (Object)task.getTaskRunUid(), (Object)task.getName());
            }
        } else {
            LOG.error("[root_run_uid: {}] unable to add tasks", (Object)rootRunUid);
        }
        return taskRunsInfo;
    }

    public void updateTaskRunAttempt(String taskRunUid, String taskRunAttemptUid, String state, ErrorInfo errorInfo, ZonedDateTime startDate) {
        this.updateTaskRunAttempt(taskRunUid, taskRunAttemptUid, state, errorInfo, startDate, null);
    }

    public void updateTaskRunAttempt(String taskRunUid, String taskRunAttemptUid, String state, ErrorInfo errorInfo, ZonedDateTime startDate, Map<String, String> linksDict) {
        UpdateTaskRunAttempts taskRunAttempts = new UpdateTaskRunAttempts(Collections.singletonList(new TaskRunAttemptUpdate(taskRunUid, taskRunAttemptUid, state, ZonedDateTime.now(ZoneOffset.UTC), startDate, errorInfo, linksDict)));
        Call<Void> call = this.dbnd.updateTaskRunAttempts(taskRunAttempts);
        Optional<Object> res = this.safeExecuteVoid(call);
        if (res.isPresent()) {
            LOG.info("[task_run_uid: {}, task_run_attempt_uid: {}] task updated with state [{}]", new Object[]{taskRunUid, taskRunAttemptUid, state});
        } else {
            LOG.error("[task_run_uid: {}, task_run_attempt_uid: {}] unable to update task with state [{}]", new Object[]{taskRunUid, taskRunAttemptUid, state});
        }
    }

    public void setRunState(String runUid, String state) {
        SetRunState data = new SetRunState(runUid, state, ZonedDateTime.now(ZoneOffset.UTC));
        Call<Void> call = this.dbnd.setRunState(data);
        Optional<Object> res = this.safeExecuteVoid(call);
        if (res.isPresent()) {
            LOG.info("[root_run_uid: {}] run state set to [{}]", (Object)runUid, (Object)state);
        } else {
            LOG.error("[root_run_uid: {}] unable to set run state to [{}]", (Object)runUid, (Object)state);
        }
    }

    public void logMetric(TaskRun taskRun, String key, String value, String source) {
        this.logMetrics(taskRun, Collections.singletonMap(key, value), source);
    }

    public void logMetrics(TaskRun taskRun, Map<String, Object> metrics, String source) {
        if (metrics.isEmpty()) {
            return;
        }
        Set<String> metricsKeys = metrics.keySet();
        Set<String> keysToLog = metricsKeys.size() > 10 ? (Collection)metricsKeys.stream().limit(10L).collect(Collectors.toList()) : metricsKeys;
        LOG.info("[task_run_uid: {}, task_name: {}] logging metrics. Total: {}, Keys: {}", new Object[]{taskRun.getTaskRunUid(), taskRun.getName(), metricsKeys.size(), keysToLog});
        List<LogMetric> metricsInfo = metrics.entrySet().stream().map(m -> new LogMetric(taskRun.getTaskRunAttemptUid(), new Metric((String)m.getKey(), m.getValue(), ZonedDateTime.now(ZoneOffset.UTC)), source)).collect(Collectors.toList());
        Optional<Object> res = this.safeExecuteVoid(this.dbnd.logMetrics(new LogMetrics(metricsInfo)));
        if (res.isPresent()) {
            LOG.info("[task_run_uid: {}, task_name: {}] metrics logged: Total: {}, Keys: {}", new Object[]{taskRun.getTaskRunUid(), taskRun.getName(), metricsKeys.size(), keysToLog});
        } else {
            LOG.error("[task_run_uid: {}, task_name: {}] unable to log metrics", (Object)taskRun.getTaskRunUid(), (Object)taskRun.getName());
        }
    }

    public void logTargets(TaskRun taskRun, List<LogTarget> targets) {
        Optional<Object> res = this.safeExecuteVoid(this.dbnd.logTargets(new LogTargets(targets)));
        if (res.isPresent()) {
            LOG.info("[task_run_uid: {}, task_name: {}] targets submitted", (Object)taskRun.getTaskRunUid(), (Object)taskRun.getName());
        } else {
            LOG.error("[task_run_uid: {}, task_name: {}] unable to submit targets", (Object)taskRun.getTaskRunUid(), (Object)taskRun.getName());
        }
    }

    public void logDatasetOperations(TaskRun taskRun, List<LogDataset> datasets) {
        for (LogDataset op : datasets) {
            LOG.info("[task_run_uid: {}, task_name: {}] logging dataset operation {}", new Object[]{taskRun.getTaskRunUid(), taskRun.getName(), op});
        }
        Optional<Object> res = this.safeExecuteVoid(this.dbnd.logDatasets(new LogDatasets(datasets)));
        if (res.isPresent()) {
            LOG.info("[task_run_uid: {}, task_name: {}] dataset operations submitted", (Object)taskRun.getTaskRunUid(), (Object)taskRun.getName());
        } else {
            LOG.error("[task_run_uid: {}, task_name: {}] unable to submit dataset operations", (Object)taskRun.getTaskRunUid(), (Object)taskRun.getName());
        }
    }

    public void saveExternalLinks(String taskRunAttemptUid, String name, String url) {
        Optional<Object> res = this.safeExecuteVoid(this.dbnd.saveExternalLinks(new SaveExternalLinks(taskRunAttemptUid, Collections.singletonMap(name, url))));
        if (res.isPresent()) {
            LOG.info("[task_run_attempt_uid: {}] external link saved", (Object)taskRunAttemptUid);
        } else {
            LOG.error("[task_run_attempt_uid: {}] Unable to save external link", (Object)taskRunAttemptUid);
        }
    }

    public void saveExternalLinks(String taskRunAttemptUid, Map<String, String> linksDict) {
        Optional<Object> res = this.safeExecuteVoid(this.dbnd.saveExternalLinks(new SaveExternalLinks(taskRunAttemptUid, linksDict)));
        if (res.isPresent()) {
            LOG.info("[task_run_attempt_uid: {}] external link saved", (Object)taskRunAttemptUid);
        } else {
            LOG.error("[task_run_attempt_uid: {}] Unable to save external link", (Object)taskRunAttemptUid);
        }
    }

    public void saveTaskLog(String taskRunUid, String taskRunAttemptUid, String logBody) {
        if (logBody == null) {
            return;
        }
        LOG.info("[task_run_uid: {}, task_run_attempt_uid: {}] submitting task log, log size: {} characters", new Object[]{taskRunUid, taskRunAttemptUid, logBody.length()});
        SaveTaskRunLog body = new SaveTaskRunLog(this.config, taskRunAttemptUid, logBody);
        Optional<Object> res = this.safeExecuteVoid(this.dbnd.saveTaskRunLog(body));
        if (res.isPresent()) {
            LOG.info("[task_run_uid: {}, task_run_attempt_uid: {}] task log submitted", (Object)taskRunUid, (Object)taskRunAttemptUid);
        } else {
            LOG.error("[task_run_uid: {}, task_run_attempt_uid: {}] Unable to submit task log", (Object)taskRunUid, (Object)taskRunAttemptUid);
        }
    }

    protected Optional<Object> safeExecuteVoid(Call<Void> call) {
        return this.safeExecuteVoid(call, false);
    }

    protected Optional<Object> safeExecuteVoid(Call<Void> call, boolean logToStdout) {
        try {
            Response<Void> res = call.execute();
            if (res.isSuccessful()) {
                return Optional.of(new Object());
            }
            LOG.error("HTTP request failed: {}/{}", (Object)res.code(), (Object)res.message());
            if (res.code() == 401) {
                LOG.error("Check DBND__CORE__DATABAND_ACCESS_TOKEN variable. Looks like token is missing or wrong");
            }
            return Optional.empty();
        }
        catch (ConnectException ex) {
            String msg = String.format("Could not connect to server: %s, %s", call.request().url(), ex.getMessage());
            if (logToStdout) {
                System.out.println(msg);
            } else {
                LOG.error(msg);
            }
            return Optional.empty();
        }
        catch (IOException e) {
            String msg = String.format("Unable to perform HTTP request to server: %s, %s", call.request().url(), e.getMessage());
            if (logToStdout) {
                System.out.println(msg);
            } else {
                LOG.error(msg);
            }
            return Optional.empty();
        }
    }

    public DbndApi api() {
        return this.dbnd;
    }
}

