/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.id;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;

public class Uuid5Raw {
    public static final UUID NAMESPACE_DNS = UUID.fromString("6ba7b810-9dad-11d1-80b4-00c04fd430c8");

    public static UUID fromString(UUID namespace, String name) {
        try {
            Objects.requireNonNull(namespace, "UUID5 namespace should not be null");
            Objects.requireNonNull(name, "UUID5 name should not be null");
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(Uuid5Raw.uuidToBytes(namespace));
            md.update(name.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            digest[6] = (byte)(digest[6] & 0xF);
            digest[6] = (byte)(digest[6] | 0x50);
            digest[8] = (byte)(digest[8] & 0x3F);
            digest[8] = (byte)(digest[8] | 0x80);
            return Uuid5Raw.bytesToUuid(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError("SHA-1 not supported");
        }
    }

    protected static UUID bytesToUuid(byte[] bytes) {
        long msb = (long)bytes[0] << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
        long lsb = (long)bytes[8] << 56 | ((long)bytes[9] & 0xFFL) << 48 | ((long)bytes[10] & 0xFFL) << 40 | ((long)bytes[11] & 0xFFL) << 32 | ((long)bytes[12] & 0xFFL) << 24 | ((long)bytes[13] & 0xFFL) << 16 | ((long)bytes[14] & 0xFFL) << 8 | (long)bytes[15] & 0xFFL;
        return new UUID(msb, lsb);
    }

    protected static byte[] uuidToBytes(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        return new byte[]{(byte)(msb >> 56), (byte)(msb >> 48), (byte)(msb >> 40), (byte)(msb >> 32), (byte)(msb >> 24), (byte)(msb >> 16), (byte)(msb >> 8), (byte)msb, (byte)(lsb >> 56), (byte)(lsb >> 48), (byte)(lsb >> 40), (byte)(lsb >> 32), (byte)(lsb >> 24), (byte)(lsb >> 16), (byte)(lsb >> 8), (byte)lsb};
    }
}

