/*
 * Decompiled with CFR 0.152.
 */
package shadow.kotlin.io.path;

import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import shadow.kotlin.Metadata;
import shadow.kotlin.jvm.internal.Intrinsics;
import shadow.kotlin.text.StringsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lshadow/kotlin/io/path/PathRelativizer;", "", "()V", "emptyPath", "Ljava/nio/file/Path;", "shadow.kotlin.jvm.PlatformType", "parentPath", "tryRelativeTo", "path", "base", "shadow.kotlin-stdlib-jdk7"})
final class PathRelativizer {
    private static final Path emptyPath;
    private static final Path parentPath;
    @NotNull
    public static final PathRelativizer INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path tryRelativeTo(@NotNull Path path, @NotNull Path base) {
        Path r;
        Path path2;
        void i;
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(base, "base");
        Path bn = base.normalize();
        Path pn = path.normalize();
        Path rn = bn.relativize(pn);
        int n = 0;
        Path path3 = bn;
        Intrinsics.checkNotNullExpressionValue(path3, "bn");
        int n2 = path3.getNameCount();
        Path path4 = pn;
        Intrinsics.checkNotNullExpressionValue(path4, "pn");
        int n3 = path4.getNameCount();
        boolean bl = false;
        int n4 = Math.min(n2, n3);
        while (n < n4 && !(Intrinsics.areEqual(bn.getName((int)i), parentPath) ^ true)) {
            if (Intrinsics.areEqual(pn.getName((int)i), parentPath) ^ true) {
                throw (Throwable)new IllegalArgumentException("Unable to compute relative path");
            }
            ++i;
        }
        if (Intrinsics.areEqual(pn, bn) ^ true && Intrinsics.areEqual(bn, emptyPath)) {
            path2 = pn;
        } else {
            String rnString = ((Object)rn).toString();
            Path path5 = rn;
            Intrinsics.checkNotNullExpressionValue(path5, "rn");
            FileSystem fileSystem = path5.getFileSystem();
            Intrinsics.checkNotNullExpressionValue(fileSystem, "rn.fileSystem");
            String string = fileSystem.getSeparator();
            Intrinsics.checkNotNullExpressionValue(string, "rn.fileSystem.separator");
            if (StringsKt.endsWith$default(rnString, string, false, 2, null)) {
                FileSystem fileSystem2 = rn.getFileSystem();
                FileSystem fileSystem3 = rn.getFileSystem();
                Intrinsics.checkNotNullExpressionValue(fileSystem3, "rn.fileSystem");
                path2 = fileSystem2.getPath(StringsKt.dropLast(rnString, fileSystem3.getSeparator().length()), new String[0]);
            } else {
                path2 = rn;
            }
        }
        Path path6 = r = path2;
        Intrinsics.checkNotNullExpressionValue(path6, "r");
        return path6;
    }

    private PathRelativizer() {
    }

    static {
        PathRelativizer pathRelativizer;
        INSTANCE = pathRelativizer = new PathRelativizer();
        emptyPath = Paths.get("", new String[0]);
        parentPath = Paths.get("..", new String[0]);
    }
}

