/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.schema;

import ai.databand.schema.TaskRunParam;
import ai.databand.schema.jackson.LocalDateDeserializer;
import ai.databand.schema.jackson.LocalDateSerializer;
import ai.databand.schema.jackson.ZonedDateTimeDeserializer;
import ai.databand.schema.jackson.ZonedDateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskRun {
    private String uid;
    private String runUid;
    private boolean isRoot;
    private boolean isSystem;
    private String logRemote;
    private String version;
    private String taskRunUid;
    private String taskSignature;
    private String name;
    private List<TaskRunParam> taskRunParams;
    private String outputSignature;
    private boolean isSkipped;
    @JsonSerialize(using=LocalDateSerializer.class)
    @JsonDeserialize(using=LocalDateDeserializer.class)
    private LocalDate targetDate;
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    private ZonedDateTime executionDate;
    private String logLocal;
    private String state;
    private String taskDefinitionUid;
    private String commandLine;
    private boolean isReused;
    private boolean hasUpstreams;
    private String taskRunAttemptUid;
    private String taskAfId;
    private boolean isDynamic;
    private boolean hasDownstreams;
    private String functionalCall;
    private String taskId;
    private String env;
    @JsonIgnore
    private StringBuilder logBuffer;
    @JsonIgnore
    private Map<String, Object> metrics;
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    private ZonedDateTime startDate;
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    private ZonedDateTime endDate;
    @JsonIgnore
    private List<TaskRun> upstreamTasks = new ArrayList<TaskRun>(1);
    private Integer latestTaskRunAttemptId;
    private Map<String, String> externalLinks;

    public TaskRun() {
    }

    public TaskRun(String runUid, boolean isRoot, boolean isSystem, String logRemote, String version, String taskRunUid, String taskSignature, String name, List<TaskRunParam> taskRunParams, String outputSignature, boolean isSkipped, LocalDate targetDate, ZonedDateTime executionDate, String logLocal, String state, String taskDefinitionUid, String commandLine, boolean isReused, boolean hasUpstreams, String taskRunAttemptUid, String taskAfId, boolean isDynamic, boolean hasDownstreams, String functionalCall, String taskId, String env, Map<String, String> externalLinks) {
        this.runUid = runUid;
        this.isRoot = isRoot;
        this.isSystem = isSystem;
        this.logRemote = logRemote;
        this.version = version;
        this.taskRunUid = taskRunUid;
        this.taskSignature = taskSignature;
        this.name = name;
        this.taskRunParams = taskRunParams;
        this.outputSignature = outputSignature;
        this.isSkipped = isSkipped;
        this.targetDate = targetDate;
        this.executionDate = executionDate;
        this.logLocal = logLocal;
        this.state = state;
        this.taskDefinitionUid = taskDefinitionUid;
        this.commandLine = commandLine;
        this.isReused = isReused;
        this.hasUpstreams = hasUpstreams;
        this.taskRunAttemptUid = taskRunAttemptUid;
        this.taskAfId = taskAfId;
        this.isDynamic = isDynamic;
        this.hasDownstreams = hasDownstreams;
        this.functionalCall = functionalCall;
        this.taskId = taskId;
        this.env = env;
        this.externalLinks = externalLinks;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public String getRunUid() {
        return this.runUid;
    }

    public void setRunUid(String runUid) {
        this.runUid = runUid;
    }

    public boolean getIsRoot() {
        return this.isRoot;
    }

    public boolean getIsSystem() {
        return this.isSystem;
    }

    public String getLogRemote() {
        return this.logRemote;
    }

    public void setLogRemote(String logRemote) {
        this.logRemote = logRemote;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTaskRunUid() {
        return this.taskRunUid;
    }

    public void setTaskRunUid(String taskRunUid) {
        this.taskRunUid = taskRunUid;
    }

    public String getTaskSignature() {
        return this.taskSignature;
    }

    public void setTaskSignature(String taskSignature) {
        this.taskSignature = taskSignature;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<TaskRunParam> getTaskRunParams() {
        return this.taskRunParams;
    }

    public void setTaskRunParams(List<TaskRunParam> taskRunParams) {
        this.taskRunParams = taskRunParams;
    }

    public String getOutputSignature() {
        return this.outputSignature;
    }

    public void setOutputSignature(String outputSignature) {
        this.outputSignature = outputSignature;
    }

    public boolean getIsSkipped() {
        return this.isSkipped;
    }

    public LocalDate getTargetDate() {
        return this.targetDate;
    }

    public void setTargetDate(LocalDate targetDate) {
        this.targetDate = targetDate;
    }

    public ZonedDateTime getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(ZonedDateTime executionDate) {
        this.executionDate = executionDate;
    }

    public String getLogLocal() {
        return this.logLocal;
    }

    public void setLogLocal(String logLocal) {
        this.logLocal = logLocal;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getTaskDefinitionUid() {
        return this.taskDefinitionUid;
    }

    public void setTaskDefinitionUid(String taskDefinitionUid) {
        this.taskDefinitionUid = taskDefinitionUid;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public boolean getIsReused() {
        return this.isReused;
    }

    public boolean getHasUpstreams() {
        return this.hasUpstreams;
    }

    public void setHasUpstreams(boolean hasUpstreams) {
        this.hasUpstreams = hasUpstreams;
    }

    public String getTaskRunAttemptUid() {
        return this.taskRunAttemptUid;
    }

    public void setTaskRunAttemptUid(String taskRunAttemptUid) {
        this.taskRunAttemptUid = taskRunAttemptUid;
    }

    public String getTaskAfId() {
        return this.taskAfId;
    }

    public void setTaskAfId(String taskAfId) {
        this.taskAfId = taskAfId;
    }

    public boolean getIsDynamic() {
        return this.isDynamic;
    }

    public boolean getHasDownstreams() {
        return this.hasDownstreams;
    }

    public void setHasDownstreams(boolean hasDownstreams) {
        this.hasDownstreams = hasDownstreams;
    }

    public String getFunctionalCall() {
        return this.functionalCall;
    }

    public void setFunctionalCall(String functionalCall) {
        this.functionalCall = functionalCall;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setRoot(boolean root) {
        this.isRoot = root;
    }

    public void setSystem(boolean system) {
        this.isSystem = system;
    }

    public void setSkipped(boolean skipped) {
        this.isSkipped = skipped;
    }

    public void setReused(boolean reused) {
        this.isReused = reused;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public ZonedDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
    }

    public Integer getLatestTaskRunAttemptId() {
        return this.latestTaskRunAttemptId;
    }

    public void setLatestTaskRunAttemptId(Integer latestTaskRunAttemptId) {
        this.latestTaskRunAttemptId = latestTaskRunAttemptId;
    }

    public Map<String, String> getExternalLinks() {
        return this.externalLinks;
    }

    public void appendLog(String msg) {
        if (this.logBuffer == null) {
            this.logBuffer = new StringBuilder();
        }
        for (TaskRun upstream : this.upstreamTasks) {
            upstream.appendLog(msg);
        }
        this.logBuffer.append(msg);
    }

    @JsonIgnore
    public String getTaskLog() {
        if (this.logBuffer == null) {
            return null;
        }
        return this.logBuffer.toString();
    }

    public void appendPrefixedMetrics(Map<String, Object> values2) {
        if (this.metrics == null) {
            this.metrics = new HashMap<String, Object>(1);
        }
        this.metrics.putAll(values2);
    }

    public void appendMetrics(Map<String, Object> values2) {
        for (TaskRun taskRun : this.upstreamTasks) {
            taskRun.appendMetrics(values2);
        }
        if (this.metrics == null) {
            this.metrics = new HashMap<String, Object>(1);
            this.metrics.putAll(values2);
            return;
        }
        for (Map.Entry entry : values2.entrySet()) {
            Object existingValue;
            String key = (String)entry.getKey();
            if (!this.metrics.containsKey(key) || !((existingValue = this.metrics.get(key)) instanceof Number)) continue;
            this.metrics.put(key, (Long)existingValue + (Long)entry.getValue());
        }
    }

    @JsonIgnore
    public Map<String, Object> getMetrics() {
        if (this.metrics == null) {
            return Collections.emptyMap();
        }
        return this.metrics;
    }

    public void addUpstream(TaskRun upstream) {
        this.upstreamTasks.add(upstream);
    }
}

