/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.agent;

import ai.databand.DbndAppLog;
import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.LoaderClassPath;
import org.slf4j.event.Level;

public class ActiveJobTransformer
implements ClassFileTransformer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (!"org/apache/spark/scheduler/ActiveJob".equalsIgnoreCase(className)) {
            return classfileBuffer;
        }
        try (ByteArrayInputStream is = new ByteArrayInputStream(classfileBuffer);){
            DbndAppLog.printfln(Level.INFO, "Databand tracking of the Spark class 'ActiveJob'", new Object[0]);
            ClassPool cp = ClassPool.getDefault();
            cp.appendClassPath(new LoaderClassPath(loader));
            CtClass ct = cp.makeClass(is);
            for (CtConstructor constructor : ct.getConstructors()) {
                if (!constructor.callsSuper()) continue;
                constructor.insertAfter("{ ai.databand.spark.ActiveJobTracker.track(this); }");
            }
            byte[] byArray = ct.toBytecode();
            return byArray;
        }
        catch (Throwable e) {
            DbndAppLog.printfln(Level.ERROR, "Databand tracking failed to modify the 'ActiveJob' class.", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }
}

