/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.agent;

import ai.databand.DbndAppLog;
import ai.databand.config.DbndAgentConfig;
import java.io.ByteArrayInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.management.ManagementFactory;
import java.security.ProtectionDomain;
import java.util.LinkedList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.MethodInfo;
import org.slf4j.LoggerFactory;

public class DbndTrackingTransformer
implements ClassFileTransformer {
    private static final String TASK_ANNOTATION = "ai.databand.annotations.Task";
    private static final DbndAppLog LOG = new DbndAppLog(LoggerFactory.getLogger(DbndTrackingTransformer.class));
    private final DbndAgentConfig config;

    public DbndTrackingTransformer(DbndAgentConfig config) {
        this.config = config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        ClassPool cp = ClassPool.getDefault();
        cp.appendClassPath(new LoaderClassPath(loader));
        try (ByteArrayInputStream is = new ByteArrayInputStream(classfileBuffer);){
            CtClass ct = cp.makeClass(is);
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            List<CtMethod> annotatedMethods = this.getAnnotatedMethods(cp, ct, className, classfileBuffer);
            if (annotatedMethods.isEmpty()) {
                byte[] byArray = null;
                return byArray;
            }
            try {
                ct.addField(CtField.make("static ai.databand.DbndWrapper $dbnd = ai.databand.DbndWrapper.instance();", ct));
            }
            catch (DuplicateMemberException duplicateMemberException) {
                // empty catch block
            }
            for (CtMethod method : annotatedMethods) {
                MethodInfo methodInfo = method.getMethodInfo();
                CtClass tr = cp.get("java.lang.Throwable");
                LOG.verbose("Databand tracking of @Task annotated method '{}.{}()'", className, methodInfo.getName());
                method.insertBefore("{ $dbnd.beforeTask(\"" + ct.getName() + "\", \"" + method.getLongName() + "\", $args); }");
                method.insertAfter("{ $dbnd.afterTask(\"" + method.getLongName() + "\", (Object) ($w) $_); }");
                method.addCatch("{ $dbnd.errorTask(\"" + method.getLongName() + "\", $e); throw $e; }", tr);
            }
            LOG.info("Databand has succesfully detected and has started tracking of {} @Task annotated methods out of {} total methods declared directly inside the class '{}'", annotatedMethods.size(), ct.getDeclaredMethods().length, className);
            Object object = ct.toBytecode();
            return object;
        }
        catch (RuntimeException e) {
            if (e.getMessage() == null) return classfileBuffer;
            if (!e.getMessage().contains("frozen")) return classfileBuffer;
            return null;
        }
        catch (Throwable e) {
            LOG.error("Databand failed to add runtime tracking to class {}", className);
            e.printStackTrace();
            return null;
        }
    }

    protected List<CtMethod> getAnnotatedMethods(ClassPool cp, CtClass ct, String className, byte[] classfileBuffer) {
        CtMethod[] declaredMethods;
        LinkedList<CtMethod> annotatedMethods = new LinkedList<CtMethod>();
        for (CtMethod method : declaredMethods = ct.getDeclaredMethods()) {
            MethodInfo methodInfo = method.getMethodInfo();
            AnnotationsAttribute attInfo = (AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations");
            if (attInfo == null || attInfo.getAnnotation(TASK_ANNOTATION) == null) continue;
            if (!this.isScalaObject(cp, className)) {
                return new LinkedList<CtMethod>();
            }
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    protected boolean isScalaObject(ClassPool cp, String className) {
        if (className.contains("$")) {
            return true;
        }
        try {
            cp.get(className + '$');
            return false;
        }
        catch (NotFoundException e) {
            return true;
        }
    }
}

