/*
 * Decompiled with CFR 0.152.
 */
package ai.databand;

import ai.databand.DbndApi;
import ai.databand.DbndClient;
import ai.databand.config.DbndConfig;
import ai.databand.config.DbndSparkConf;
import ai.databand.config.Env;
import ai.databand.config.JavaOpts;
import ai.databand.config.SimpleProps;
import ai.databand.schema.auth.CreateTokenReq;
import ai.databand.schema.auth.CreateTokenRes;
import ai.databand.schema.auth.LoginReq;
import ai.databand.schema.auth.LoginRes;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import retrofit2.Response;
import shadow.okhttp3.Headers;

public class ApiWithTokenBuilder {
    public DbndApi api() throws IOException {
        DbndConfig config = new DbndConfig();
        DbndClient dbnd = new DbndClient(config);
        DbndApi api = dbnd.api();
        Response<Void> csrfRes = api.csrfToken().execute();
        Optional<String> optionalCookie = csrfRes.headers().values("set-cookie").stream().filter(cookieStr -> cookieStr.contains("X-CSRF-TOKEN")).findFirst();
        final String csrfToken = optionalCookie.orElseThrow(NullPointerException::new).split(";")[0].split("=")[1];
        String cookie = Objects.requireNonNull(csrfRes.headers().get("set-cookie")).concat(";");
        Response<LoginRes> loginRes = api.login(new LoginReq(), cookie, csrfToken).execute();
        Headers headers = loginRes.headers();
        cookie = Objects.requireNonNull(headers.get("set-cookie")).concat(";");
        Response<CreateTokenRes> tokenRes = api.createPersonalAccessToken(new CreateTokenReq(), cookie, csrfToken).execute();
        CreateTokenRes tokenResBody = tokenRes.body();
        Objects.requireNonNull(tokenResBody, "Token response body should not be empty");
        final String token = tokenResBody.getToken();
        final String finalCookie = cookie;
        HashMap<String, String> tokens = new HashMap<String, String>(){
            {
                this.put("dbnd.core.databand_access_token", token);
                this.put("dbnd.csrf_token", csrfToken);
                this.put("dbnd.session_cookie", finalCookie);
            }
        };
        DbndConfig configWithToken = new DbndConfig(new DbndSparkConf(new Env(new JavaOpts(new SimpleProps((Map<String, String>)tokens)))));
        return new DbndClient(configWithToken).api();
    }
}

