/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.azkaban;

import ai.databand.azkaban.AzkabanEvent;
import ai.databand.azkaban.events.DefaultEvent;
import ai.databand.azkaban.events.FlowFinishedEvent;
import ai.databand.azkaban.events.FlowStartedEvent;
import ai.databand.azkaban.events.JobFinishedEvent;
import ai.databand.azkaban.events.JobStartedEvent;
import azkaban.event.Event;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbndEventReporter {
    private static final Logger LOG = LoggerFactory.getLogger(DbndEventReporter.class);
    private final Map<Event.Type, Class<? extends AzkabanEvent>> events = new HashMap<Event.Type, Class<? extends AzkabanEvent>>(1);

    public DbndEventReporter() {
        this.events.put(Event.Type.FLOW_STARTED, FlowStartedEvent.class);
        this.events.put(Event.Type.FLOW_FINISHED, FlowFinishedEvent.class);
        this.events.put(Event.Type.JOB_STARTED, JobStartedEvent.class);
        this.events.put(Event.Type.JOB_FINISHED, JobFinishedEvent.class);
    }

    public boolean report(Event reportedEvent) {
        try {
            Class<DefaultEvent> type = this.events.getOrDefault(reportedEvent.getType(), DefaultEvent.class);
            AzkabanEvent event = (AzkabanEvent)type.getConstructor(Event.class).newInstance(reportedEvent);
            event.track();
        }
        catch (Throwable e) {
            LOG.error("Unable to track event", e);
        }
        return true;
    }
}

