/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.azkaban.events;

import ai.databand.azkaban.AgentAzkabanLinks;
import ai.databand.azkaban.links.AzkabanLinks;
import ai.databand.config.DbndConfig;
import ai.databand.schema.AzkabanTaskContext;
import azkaban.event.Event;
import azkaban.execapp.FlowRunner;
import azkaban.executor.ExecutableFlow;
import azkaban.flow.Flow;
import azkaban.project.JdbcProjectLoader;
import azkaban.project.Project;
import azkaban.project.ProjectLoader;
import azkaban.project.ProjectManager;
import azkaban.server.AzkabanServer;
import azkaban.utils.Props;

public class FlowRunnerContext {
    private final ExecutableFlow executableFlow;
    private final FlowRunner flowRunner;
    private final Flow flowDef;
    private final String flowId;
    private final String projectName;
    private final String flowUuid;
    private final String executionId;
    private final String startTime;
    private final String pipelineName;
    private final DbndConfig config;

    public FlowRunnerContext(Event event, DbndConfig config) {
        this.flowRunner = (FlowRunner)event.getRunner();
        this.executableFlow = this.flowRunner.getExecutableFlow();
        this.flowId = this.executableFlow.getId();
        this.projectName = this.executableFlow.getProjectName();
        this.flowUuid = this.executableFlow.getInputProps().get((Object)"azkaban.flow.uuid");
        this.executionId = String.valueOf(this.executableFlow.getExecutionId());
        this.startTime = String.valueOf(event.getTime());
        ProjectManager projectManager = new ProjectManager((ProjectLoader)new JdbcProjectLoader(AzkabanServer.getAzkabanProperties()), AzkabanServer.getAzkabanProperties());
        Project project = projectManager.getProject(this.projectName);
        this.flowDef = project.getFlow(this.flowId);
        this.pipelineName = String.format("%s__%s", this.projectName, this.flowId);
        this.config = config;
    }

    public ExecutableFlow executableFlow() {
        return this.executableFlow;
    }

    public FlowRunner flowRunner() {
        return this.flowRunner;
    }

    public String startTime() {
        return this.startTime;
    }

    public AzkabanTaskContext taskContext() {
        return new AzkabanTaskContext(this.projectName, this.flowId, this.flowUuid, this.executionId, "", this.config);
    }

    public AzkabanLinks links() {
        return new AgentAzkabanLinks(this.executableFlow);
    }

    public Flow flowDef() {
        return this.flowDef;
    }

    public String pipelineName() {
        return this.pipelineName;
    }

    public String envName() {
        Props systemProps = AzkabanServer.getAzkabanProperties();
        return String.format("%s: %s", systemProps.get((Object)"azkaban.name"), systemProps.get((Object)"azkaban.label"));
    }

    public boolean isTrack() {
        return false;
    }
}

