/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.azkaban.events;

import ai.databand.DbndClient;
import ai.databand.azkaban.AzkabanDbndConfig;
import ai.databand.azkaban.AzkabanEvent;
import ai.databand.azkaban.AzkabanJob;
import ai.databand.config.DbndConfig;
import ai.databand.schema.AzkabanTaskContext;
import ai.databand.schema.ErrorInfo;
import java.util.Optional;

public class JobFinished
implements AzkabanEvent {
    private final DbndConfig config;
    private final AzkabanJob job;
    private final AzkabanTaskContext azCtx;
    private final DbndClient dbnd;
    private final String failureMessage;

    public JobFinished(DbndConfig config, AzkabanTaskContext azCtx, AzkabanJob job, String failureMessage) {
        this.config = config;
        this.dbnd = new DbndClient(config);
        this.azCtx = azCtx;
        this.job = job;
        this.failureMessage = failureMessage;
    }

    @Override
    public void track() {
        AzkabanDbndConfig azConfig = new AzkabanDbndConfig(this.config);
        if (!azConfig.isTrackingEnabled(this.azCtx)) {
            return;
        }
        this.dbnd.saveTaskLog(this.azCtx.taskRunAttemptUid(), this.job.log());
        Optional<Object> errorInfo = Optional.empty();
        if (this.job.isFailed()) {
            errorInfo = Optional.of(new ErrorInfo(this.failureMessage, "", false, "", "", "", false, "AzkabanExecutionError"));
        }
        this.dbnd.updateTaskRunAttempt(this.azCtx.taskRunUid(), this.azCtx.taskRunAttemptUid(), this.job.state(), errorInfo.orElse(null), this.job.startDate());
    }
}

