/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.schema.jackson;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class ZonedDateTimeDeserializer
extends StdDeserializer<ZonedDateTime> {
    private final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX";
    private final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX");

    public ZonedDateTimeDeserializer() {
        this((Class<ZonedDateTime>)null);
    }

    public ZonedDateTimeDeserializer(Class<ZonedDateTime> t) {
        super(t);
    }

    @Override
    public ZonedDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String value = p.getValueAsString();
        try {
            return ZonedDateTime.parse(value, this.FORMATTER);
        }
        catch (Exception e) {
            return ZonedDateTime.parse(value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
    }
}

