/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.schema.jackson;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class ZonedDateTimeSerializer
extends StdSerializer<ZonedDateTime> {
    private static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX";
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXX");

    public ZonedDateTimeSerializer() {
        this((Class<ZonedDateTime>)null);
    }

    public ZonedDateTimeSerializer(Class<ZonedDateTime> t) {
        super(t);
    }

    @Override
    public void serialize(ZonedDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(value.format(FORMATTER));
    }
}

