/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.schema;

import ai.databand.schema.jackson.ZonedDateTimeDeserializer;
import ai.databand.schema.jackson.ZonedDateTimeSerializer;
import java.time.ZonedDateTime;
import shadow.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import shadow.com.fasterxml.jackson.databind.annotation.JsonSerialize;

public class Metric {
    private final String key;
    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    @JsonDeserialize(using=ZonedDateTimeDeserializer.class)
    private final ZonedDateTime timestamp;
    private Object value;
    private Integer valueInt;
    private Double valueFloat;
    private Object valueJson;
    private String valueStr;

    public Metric(String key, Object metricValue, ZonedDateTime timestamp) {
        this.key = key;
        this.value = metricValue;
        if (metricValue instanceof String) {
            this.valueStr = (String)metricValue;
            try {
                this.valueInt = new Integer(this.valueStr);
            }
            catch (NumberFormatException e) {
                this.valueInt = null;
            }
            if (this.valueStr.contains(".")) {
                try {
                    this.valueFloat = new Double(this.valueStr);
                }
                catch (NumberFormatException e) {
                    this.valueFloat = null;
                }
            }
        } else if (metricValue instanceof Long) {
            Long value = (Long)metricValue;
            if (value <= Integer.MAX_VALUE) {
                this.valueInt = value.intValue();
            } else {
                this.valueStr = value.toString();
            }
        } else if (metricValue instanceof Integer) {
            this.valueInt = (Integer)metricValue;
        } else if (metricValue instanceof Double) {
            this.valueFloat = (Double)metricValue;
        } else {
            this.valueJson = metricValue;
        }
        this.timestamp = timestamp;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public Integer getValueInt() {
        return this.valueInt;
    }

    public Double getValueFloat() {
        return this.valueFloat;
    }

    public Object getValueJson() {
        return this.valueJson;
    }

    public String getValueStr() {
        return this.valueStr;
    }
}

