/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.azkaban;

import ai.databand.config.DbndConfig;
import ai.databand.schema.AzkabanTaskContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AzkabanDbndConfig {
    private final Set<String> projectsToTrack;
    private final Set<String> flowsToTrack;

    public AzkabanDbndConfig(DbndConfig dbndConfig) {
        this(dbndConfig.values());
    }

    public AzkabanDbndConfig(Map<String, String> props) {
        this(props.get("dbnd.azkaban.sync_projects"), props.get("dbnd.azkaban.sync_flows"));
    }

    public AzkabanDbndConfig(String syncProjects, String syncFlows) {
        this.projectsToTrack = syncProjects == null || syncProjects.isEmpty() ? Collections.emptySet() : Arrays.stream(syncProjects.split(",")).map(String::toLowerCase).collect(Collectors.toSet());
        this.flowsToTrack = syncFlows == null || syncFlows.isEmpty() ? Collections.emptySet() : Arrays.stream(syncFlows.split(",")).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public boolean isTrackingEnabled(String projectName, String flowName) {
        if (this.projectsToTrack.isEmpty() && this.flowsToTrack.isEmpty()) {
            return true;
        }
        if (!this.projectsToTrack.isEmpty() && !this.flowsToTrack.isEmpty()) {
            return this.projectsToTrack.contains(projectName.toLowerCase()) || this.flowsToTrack.contains(flowName.toLowerCase());
        }
        if (!this.projectsToTrack.isEmpty()) {
            return this.projectsToTrack.contains(projectName.toLowerCase());
        }
        return this.flowsToTrack.contains(flowName.toLowerCase());
    }

    public boolean isTrackingEnabled(AzkabanTaskContext ctx) {
        return this.isTrackingEnabled(ctx.projectName(), ctx.flowId());
    }
}

