/*
 * Decompiled with CFR 0.152.
 */
package ai.databand;

import ai.databand.DbndApi;
import ai.databand.config.DbndConfig;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.com.fasterxml.jackson.databind.PropertyNamingStrategy;

public class DbndApiBuilder {
    private final DbndConfig config;

    public DbndApiBuilder(DbndConfig config) {
        this.config = config;
    }

    public DbndApi build() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        }
        catch (NoSuchFieldError e) {
            objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).followRedirects(false).followSslRedirects(false).protocols(Collections.singletonList(Protocol.HTTP_1_1)).retryOnConnectionFailure(true);
        if (this.config.personalAccessToken().isPresent()) {
            clientBuilder.addInterceptor(chain -> {
                Request origin = chain.request();
                Request withAuth = origin.newBuilder().addHeader("Authorization", String.format("Bearer %s", this.config.personalAccessToken().get())).build();
                return chain.proceed(withAuth);
            });
        }
        clientBuilder.addInterceptor(chain -> {
            Request origin = chain.request();
            Response response = chain.proceed(origin);
            if (!response.isRedirect()) {
                return response;
            }
            String newLocation = response.header("Location");
            if (newLocation == null) {
                return response;
            }
            Request withNewLocation = origin.newBuilder().url(newLocation).build();
            return chain.proceed(withNewLocation);
        });
        OkHttpClient client = clientBuilder.build();
        Retrofit.Builder builder = new Retrofit.Builder().client(client).baseUrl(this.config.databandUrl()).addConverterFactory(JacksonConverterFactory.create(objectMapper));
        return builder.build().create(DbndApi.class);
    }
}

