/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.parameters;

import ai.databand.parameters.DatasetPreview;
import ai.databand.schema.DatasetOperationSchema;
import ai.databand.schema.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import shadow.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;

public class DatasetOperationPreview
extends DatasetPreview {
    @Override
    public Object schema(Dataset<Row> input) {
        Dataset schemaAlias = input.alias(String.format("%s_%s", "DBND_INTERNAL", "SCHEMA"));
        return this.extractSchema(schemaAlias.schema(), schemaAlias.count()).left();
    }

    public Pair<String, List<Long>> extractSchema(StructType schema, long rows) {
        try {
            ArrayList<String> columns = new ArrayList<String>(schema.fields().length);
            HashMap<String, String> dtypes = new HashMap<String, String>(schema.fields().length);
            for (StructField field : schema.fields()) {
                columns.add(field.name());
                dtypes.put(field.name(), field.dataType().typeName());
            }
            List<Long> shape = Arrays.asList(rows, columns.size());
            try {
                return new Pair<String, List<Long>>(new ObjectMapper().writeValueAsString(new DatasetOperationSchema(columns, dtypes, shape)), shape);
            }
            catch (JsonProcessingException e) {
                return new Pair<String, List<Long>>("", shape);
            }
        }
        catch (Exception e) {
            return new Pair<String, List<Long>>("", Collections.emptyList());
        }
    }
}

