/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import shadow.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shadow.com.fasterxml.jackson.databind.ser.std.NonTypedScalarSerializerBase;

@JacksonStdImpl
public final class BooleanSerializer
extends NonTypedScalarSerializerBase<Boolean> {
    private static final long serialVersionUID = 1L;
    protected final boolean _forPrimitive;

    public BooleanSerializer(boolean forPrimitive) {
        super(Boolean.class);
        this._forPrimitive = forPrimitive;
    }

    @Override
    public void serialize(Boolean value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeBoolean(value);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("boolean", !this._forPrimitive);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectBooleanFormat(typeHint);
        }
    }
}

