/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.azkaban.links;

import ai.databand.azkaban.links.AzkabanLinks;
import java.util.HashMap;
import java.util.Map;

public class DefaultAzkabanLinks
implements AzkabanLinks {
    private final String url;
    private final String projectName;
    private final String flowName;
    private final String executionId;

    public DefaultAzkabanLinks(String projectName, String flowName, String executionId, String protocol, String hostName, String port) {
        this.projectName = projectName;
        this.flowName = flowName;
        this.executionId = executionId;
        this.url = String.format("%s://%s:%s", protocol, hostName, port);
    }

    public String executionLink() {
        return String.format("%s/executor?execid=%s", this.url, this.executionId);
    }

    public String jobLogsLink(String jobId) {
        if (jobId.isEmpty()) {
            return this.executionLink();
        }
        return String.format("%s/executor?execid=%s&job=%s", this.url, this.executionId, jobId);
    }

    public String flowLink() {
        if (this.flowName.isEmpty()) {
            return this.url;
        }
        return String.format("%s/manager?project=%s&flow=%s", this.url, this.projectName, this.flowName);
    }

    @Override
    public Map<String, String> flowLinks() {
        HashMap<String, String> links = new HashMap<String, String>(2);
        links.put("azkaban flow", this.flowLink());
        links.put("azkaban flow execution", this.executionLink());
        return links;
    }

    @Override
    public Map<String, String> jobLinks(String jobId) {
        HashMap<String, String> links = new HashMap<String, String>(2);
        links.put("azkaban flow execution", this.executionLink());
        links.put("azkaban job logs", this.jobLogsLink(jobId));
        return links;
    }
}

