/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.config;

import ai.databand.config.NormalizedProps;
import ai.databand.config.PropertiesSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbndSparkConf
implements PropertiesSource {
    private static final Logger LOG = LoggerFactory.getLogger(DbndSparkConf.class);
    private final Map<String, String> props;

    public DbndSparkConf(PropertiesSource parent) {
        Map<String, String> sparkConf;
        try {
            sparkConf = this.sparkConfToMap(new SparkConf());
        }
        catch (Exception e) {
            LOG.warn("Databand is unable to resolve active spark session, 'spark.env.DBND...' variables won't be parsed");
            sparkConf = Collections.emptyMap();
        }
        HashMap<String, String> sparkProps = new HashMap<String, String>(1);
        this.props = new HashMap<String, String>(parent.values());
        for (Map.Entry<String, String> next : sparkConf.entrySet()) {
            if (!next.getKey().startsWith("spark.env.")) continue;
            sparkProps.put(next.getKey().replace("spark.env.", ""), next.getValue());
        }
        this.props.putAll(new NormalizedProps(sparkProps).values());
    }

    private Map<String, String> sparkConfToMap(SparkConf sparkConf) {
        HashMap<String, String> result = new HashMap<String, String>();
        Arrays.stream(sparkConf.getAll()).forEach(x -> {
            String cfr_ignored_0 = (String)result.put((String)x._1(), (String)x._2);
        });
        return result;
    }

    @Override
    public Map<String, String> values() {
        return Collections.unmodifiableMap(this.props);
    }

    @Override
    public Optional<String> getValue(String key) {
        return Optional.ofNullable(this.props.get(key));
    }
}

