/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.azkaban;

import ai.databand.azkaban.AzkabanApi;
import ai.databand.azkaban.CreateProjectRes;
import ai.databand.azkaban.ExecuteFlowRes;
import ai.databand.azkaban.FetchFlowExecutionRes;
import ai.databand.azkaban.LoginRes;
import ai.databand.azkaban.UploadProjectRes;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class AzkabanClient {
    private final AzkabanApi api;

    public AzkabanClient(String azkabanUrl) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).writeTimeout(60L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        this.api = (AzkabanApi)new Retrofit.Builder().client(clientBuilder.build()).baseUrl(azkabanUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(AzkabanApi.class);
    }

    public Optional<String> login(String username, String password) {
        try {
            Response res = this.api.login(username, password).execute();
            LoginRes body = (LoginRes)res.body();
            if (body != null) {
                return Optional.of(body.getSessionId());
            }
            return Optional.empty();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Optional<String> createProject(String sessionId, String name, String description) {
        try {
            Response res = this.api.createProject(sessionId, name, description).execute();
            CreateProjectRes body = (CreateProjectRes)res.body();
            if (body != null && body.isSuccess()) {
                return Optional.of(name);
            }
            return Optional.empty();
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public boolean uploadProject(String sessionId, String project, byte[] fileContent) {
        RequestBody file = MultipartBody.create((MediaType)MediaType.parse((String)"application/zip"), (byte[])fileContent);
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"file", (String)"project.zip", (RequestBody)file);
        MultipartBody.Part projectNamePart = MultipartBody.Part.createFormData((String)"project", (String)project);
        MultipartBody.Part sessionIdPart = MultipartBody.Part.createFormData((String)"session.id", (String)sessionId);
        MultipartBody.Part action = MultipartBody.Part.createFormData((String)"ajax", (String)"upload");
        try {
            Response res = this.api.uploadProject(action, sessionIdPart, projectNamePart, filePart).execute();
            UploadProjectRes body = (UploadProjectRes)res.body();
            return body != null && body.getError() == null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Optional<Integer> executeFlow(String sessionId, String project, String flow) {
        try {
            Response res = this.api.executeFlow(sessionId, project, flow).execute();
            ExecuteFlowRes body = (ExecuteFlowRes)res.body();
            if (body == null || !body.isSuccess()) {
                return Optional.empty();
            }
            return Optional.of(body.getExecId());
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public Optional<FetchFlowExecutionRes> fetchFlowExecution(String sessionId, Integer executionId) {
        try {
            Response res = this.api.fetchFlowExecution(sessionId, executionId).execute();
            FetchFlowExecutionRes body = (FetchFlowExecutionRes)res.body();
            if (body == null || !body.isSuccess()) {
                return Optional.empty();
            }
            return Optional.of(body);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

