/*
 * Decompiled with CFR 0.152.
 */
package ai.databand;

import ai.databand.DbndApi;
import ai.databand.DbndClient;
import ai.databand.config.DbndConfig;
import ai.databand.config.DbndSparkConf;
import ai.databand.config.Env;
import ai.databand.config.JavaOpts;
import ai.databand.config.SimpleProps;
import ai.databand.schema.auth.CreateTokenReq;
import ai.databand.schema.auth.CreateTokenRes;
import ai.databand.schema.auth.LoginReq;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import okhttp3.Headers;
import retrofit2.Response;

public class ApiWithTokenBuilder {
    public DbndApi api() throws IOException {
        DbndConfig config = new DbndConfig();
        DbndClient dbnd = new DbndClient(config);
        DbndApi api = dbnd.api();
        Response loginRes = api.login(new LoginReq()).execute();
        Headers headers = loginRes.headers();
        String cookie = Objects.requireNonNull(headers.get("set-cookie")).concat(";");
        Response tokenRes = api.createPersonalAccessToken(new CreateTokenReq(), cookie).execute();
        CreateTokenRes tokenResBody = (CreateTokenRes)tokenRes.body();
        Objects.requireNonNull(tokenResBody, "Token response body should not be empty");
        String token = tokenResBody.getToken();
        DbndConfig configWithToken = new DbndConfig(new DbndSparkConf(new Env(new JavaOpts(new SimpleProps(Collections.singletonMap("dbnd.core.databand_access_token", token))))));
        return new DbndClient(configWithToken).api();
    }
}

