/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rikai;

import org.apache.spark.sql.rikai.Box2dType;
import org.apache.spark.sql.rikai.Utils$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

@SQLUserDefinedType(udt=Box2dType.class)
@ScalaSignature(bytes="\u0006\u000154A!\u0005\n\u0001;!AA\u0005\u0001BC\u0002\u0013\u0005Q\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003'\u0011!Q\u0003A!b\u0001\n\u0003)\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u00111\u0002!Q1A\u0005\u0002\u0015B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\n\u0005\t]\u0001\u0011)\u0019!C\u0001K!Aq\u0006\u0001B\u0001B\u0003%a\u0005C\u00031\u0001\u0011\u0005\u0011\u0007C\u00039\u0001\u0011\u0005\u0013\bC\u0003C\u0001\u0011\u00051\tC\u0003J\u0001\u0011\u0005!\nC\u0003M\u0001\u0011\u0005Q\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003R\u0001\u0011\u0005!\u000bC\u0003U\u0001\u0011\u0005SKA\u0003C_b\u0014DM\u0003\u0002\u0014)\u0005)!/[6bS*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\tal\u0017N\\\u000b\u0002MA\u0011qdJ\u0005\u0003Q\u0001\u0012a\u0001R8vE2,\u0017!\u0002=nS:\u0004\u0013\u0001B=nS:\fQ!_7j]\u0002\nA\u0001_7bq\u0006)\u00010\\1yA\u0005!\u00110\\1y\u0003\u0015IX.\u0019=!\u0003\u0019a\u0014N\\5u}Q)!\u0007N\u001b7oA\u00111\u0007A\u0007\u0002%!)A%\u0003a\u0001M!)!&\u0003a\u0001M!)A&\u0003a\u0001M!)a&\u0003a\u0001M\u00051Q-];bYN$\"AO\u001f\u0011\u0005}Y\u0014B\u0001\u001f!\u0005\u001d\u0011un\u001c7fC:DQA\u0010\u0006A\u0002}\n\u0011A\u0019\t\u0003?\u0001K!!\u0011\u0011\u0003\u0007\u0005s\u00170\u0001\u0003%C6\u0004HC\u0001#H!\ryRIM\u0005\u0003\r\u0002\u0012aa\u00149uS>t\u0007\"\u0002%\f\u0001\u0004\u0011\u0014\u0001\u0002;iCR\f\u0011\"\u001b8uKJ\u001cXm\u0019;\u0015\u0005\u0011[\u0005\"\u0002%\r\u0001\u0004\u0011\u0014\u0001C8wKJd\u0017\r]:\u0015\u0005ir\u0005\"\u0002%\u000e\u0001\u0004\u0011\u0014\u0001B1sK\u0006$\u0012AJ\u0001\u0004S>,HC\u0001\u0014T\u0011\u0015Au\u00021\u00013\u0003!!xn\u0015;sS:<G#\u0001,\u0011\u0005]sfB\u0001-]!\tI\u0006%D\u0001[\u0015\tYF$\u0001\u0004=e>|GOP\u0005\u0003;\u0002\na\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011Q\f\t\u0015\u0005\u0001\tD\u0017\u000e\u0005\u0002dM6\tAM\u0003\u0002f)\u0005)A/\u001f9fg&\u0011q\r\u001a\u0002\u0013'FcUk]3s\t\u00164\u0017N\\3e)f\u0004X-A\u0002vIR\u001c\u0013A\u001b\t\u0003g-L!\u0001\u001c\n\u0003\u0013\t{\u0007P\r3UsB,\u0007")
public class Box2d {
    private final double xmin;
    private final double ymin;
    private final double xmax;
    private final double ymax;

    public double xmin() {
        return this.xmin;
    }

    public double ymin() {
        return this.ymin;
    }

    public double xmax() {
        return this.xmax;
    }

    public double ymax() {
        return this.ymax;
    }

    public boolean equals(Object b) {
        boolean bl;
        Object object = b;
        if (object instanceof Box2d) {
            Box2d box2d = (Box2d)object;
            bl = Utils$.MODULE$.approxEqual(this.xmin(), box2d.xmin()) && Utils$.MODULE$.approxEqual(this.ymin(), box2d.ymin()) && Utils$.MODULE$.approxEqual(this.xmax(), box2d.xmax()) && Utils$.MODULE$.approxEqual(this.ymax(), box2d.ymax());
        } else {
            bl = false;
        }
        return bl;
    }

    public Option<Box2d> $amp(Box2d that) {
        return this.intersect(that);
    }

    public Option<Box2d> intersect(Box2d that) {
        if (this.xmin() > that.xmin()) {
            return that.intersect(this);
        }
        if (this.xmax() <= that.xmin()) {
            return None$.MODULE$;
        }
        if (this.ymin() > that.ymin()) {
            return that.intersect(this);
        }
        if (this.ymax() <= that.ymin()) {
            return None$.MODULE$;
        }
        double x$1 = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(this.xmin()), that.xmin());
        double x$2 = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(this.ymax()), that.ymax());
        double x$3 = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(this.ymin()), that.ymin());
        double x$4 = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(this.ymax()), that.ymax());
        return new Some((Object)new Box2d(x$1, x$3, x$2, x$4));
    }

    public boolean overlaps(Box2d that) {
        return this.$amp(that).isDefined();
    }

    public double area() {
        return (this.ymax() - this.ymin()) * (this.xmax() - this.xmin());
    }

    public double iou(Box2d that) {
        double interArea = BoxesRunTime.unboxToDouble((Object)this.$amp(that).map((Function1 & java.io.Serializable & Serializable)b -> BoxesRunTime.boxToDouble((double)((Box2d)b).area())).getOrElse((Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> 0.0));
        return interArea / (this.area() + that.area() - interArea);
    }

    public String toString() {
        Double arg$macro$1 = BoxesRunTime.boxToDouble((double)this.xmin());
        Double arg$macro$2 = BoxesRunTime.boxToDouble((double)this.ymin());
        Double arg$macro$3 = BoxesRunTime.boxToDouble((double)this.xmax());
        Double arg$macro$4 = BoxesRunTime.boxToDouble((double)this.ymax());
        return new StringOps("Box2d(xmin=%s, ymin=%s, xmax=%s, ymax=%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4}));
    }

    public Box2d(double xmin, double ymin, double xmax, double ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }
}

