/*
 * Decompiled with CFR 0.152.
 */
package ai.eto.rikai.sql.model;

import ai.eto.rikai.sql.model.Model;
import ai.eto.rikai.sql.model.ModelNotFoundException;
import ai.eto.rikai.sql.model.ModelRegistryAlreadyExistException;
import ai.eto.rikai.sql.model.ModelResolveException;
import ai.eto.rikai.sql.model.Registry;
import java.io.Serializable;
import java.net.URI;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Registry$ {
    public static Registry$ MODULE$;
    private final Logger logger;
    private final String REGISTRY_IMPL_PREFIX;
    private final String REGISTRY_IMPL_SUFFIX;
    private final Map<String, String> DEFAULT_REGISTRIES;
    private Map<String, Registry> registryMap;

    static {
        new Registry$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String REGISTRY_IMPL_PREFIX() {
        return this.REGISTRY_IMPL_PREFIX;
    }

    public String REGISTRY_IMPL_SUFFIX() {
        return this.REGISTRY_IMPL_SUFFIX;
    }

    public Map<String, String> DEFAULT_REGISTRIES() {
        return this.DEFAULT_REGISTRIES;
    }

    private Map<String, Registry> registryMap() {
        return this.registryMap;
    }

    private void registryMap_$eq(Map<String, Registry> x$1) {
        this.registryMap = x$1;
    }

    private void verifySchema(String schema) throws ModelResolveException {
        String schemaRegex = "[a-zA-Z][\\w\\+]{0,255}";
        if (!schema.matches(schemaRegex)) {
            throw new ModelResolveException(new StringBuilder(27).append("Schema '").append(schema).append("' does not match '").append(schemaRegex).append("'").toString());
        }
    }

    public void registerAll(Map<String, String> conf) {
        this.DEFAULT_REGISTRIES().$plus$plus(conf).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Registry$.$anonfun$registerAll$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Registry$.$anonfun$registerAll$2(conf, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Model resolve(String uri, Option<String> name, Option<Map<String, String>> options) throws ModelResolveException, ModelNotFoundException {
        URI parsedUri = new URI(uri);
        String schema = parsedUri.getScheme();
        Option option = this.registryMap().get((Object)schema);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new ModelResolveException(new StringBuilder(41).append("Model registry schema '").append(schema).append("' is not supported").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Registry registry = (Registry)some.value();
        Model model = registry.resolve(uri, name, options);
        return model;
    }

    public Option<String> resolve$default$2() {
        return None$.MODULE$;
    }

    public Option<Map<String, String>> resolve$default$3() {
        return None$.MODULE$;
    }

    public void reset() {
        this.registryMap_$eq((Map<String, Registry>)Predef$.MODULE$.Map().empty());
    }

    public static final /* synthetic */ boolean $anonfun$registerAll$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$registerAll$2(Map conf$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            if (key.startsWith(MODULE$.REGISTRY_IMPL_PREFIX()) && key.endsWith(MODULE$.REGISTRY_IMPL_SUFFIX())) {
                String schema = key.substring(MODULE$.REGISTRY_IMPL_PREFIX().length(), key.length() - MODULE$.REGISTRY_IMPL_SUFFIX().length());
                MODULE$.verifySchema(schema);
                if (MODULE$.registryMap().contains((Object)schema)) {
                    throw new ModelRegistryAlreadyExistException(new StringBuilder(22).append("ModelRegistry(").append(schema).append(") exists").toString());
                }
                MODULE$.registryMap_$eq((Map<String, Registry>)MODULE$.registryMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)schema), (Object)((Registry)Class.forName(value).getDeclaredConstructor(Map.class).newInstance(conf$1)))));
                MODULE$.logger().debug((Object)new StringBuilder(31).append("Model Registry ").append(schema).append(" registered to: ").append(value).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private Registry$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
        this.REGISTRY_IMPL_PREFIX = "rikai.sql.ml.registry.";
        this.REGISTRY_IMPL_SUFFIX = ".impl";
        this.DEFAULT_REGISTRIES = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rikai.sql.ml.registry.file.impl"), (Object)"ai.eto.rikai.sql.model.fs.FileSystemRegistry"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rikai.sql.ml.registry.mlflow.impl"), (Object)"ai.eto.rikai.sql.model.mlflow.MlflowRegistry")}));
        this.registryMap = Predef$.MODULE$.Map().empty();
    }
}

