/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mlflow.api.proto.Service;
import org.mlflow.tracking.EmptyPage;
import org.mlflow.tracking.MlflowClient;
import org.mlflow.tracking.Page;

public class RunsPage
implements Page<Service.Run> {
    private final String token;
    private final List<Service.Run> runs;
    private final MlflowClient client;
    private final List<String> experimentIds;
    private final String searchFilter;
    private final Service.ViewType runViewType;
    private final List<String> orderBy;
    private final int maxResults;

    RunsPage(List<Service.Run> runs, String token, List<String> experimentIds, String searchFilter, Service.ViewType runViewType, int maxResults, List<String> orderBy, MlflowClient client) {
        this.runs = Collections.unmodifiableList(runs);
        this.token = token;
        this.experimentIds = experimentIds;
        this.searchFilter = searchFilter;
        this.runViewType = runViewType;
        this.orderBy = orderBy;
        this.maxResults = maxResults;
        this.client = client;
    }

    @Override
    public int getPageSize() {
        return this.runs.size();
    }

    @Override
    public boolean hasNextPage() {
        return this.token != null && this.token != "";
    }

    @Override
    public Optional<String> getNextPageToken() {
        if (this.hasNextPage()) {
            return Optional.of(this.token);
        }
        return Optional.empty();
    }

    @Override
    public Page<Service.Run> getNextPage() {
        if (this.hasNextPage()) {
            return this.client.searchRuns(this.experimentIds, this.searchFilter, this.runViewType, this.maxResults, this.orderBy, this.token);
        }
        return new EmptyPage<Service.Run>();
    }

    @Override
    public List<Service.Run> getItems() {
        return this.runs;
    }
}

