/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rikai.model;

import ai.eto.rikai.sql.model.ModelSpec;
import ai.eto.rikai.sql.model.SparkUDFModel;
import ai.eto.rikai.sql.spark.Python$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.api.python.PythonFunction;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.python.UserDefinedPythonFunction;
import org.apache.spark.sql.rikai.model.ModelResolver;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.JsonMethods$;
import org.json4s.jackson.Serialization$;
import org.json4s.package$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.util.Random$;

public final class ModelResolver$ {
    public static ModelResolver$ MODULE$;

    static {
        new ModelResolver$();
    }

    private void registerUdf(SparkSession session, Seq<Object> cmd, String funcName, DataType returnType, int evalType) {
        UserDefinedPythonFunction udf = new UserDefinedPythonFunction(funcName, new PythonFunction(cmd, new HashMap(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), Python$.MODULE$.pythonExec(), Python$.MODULE$.pythonVer(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.empty()).asJava(), null), returnType, evalType, true);
        session.udf().registerPython(funcName, udf);
    }

    public SparkUDFModel resolve(SparkSession session, String registryClassName, ModelSpec spec) {
        SparkUDFModel sparkUDFModel;
        Path specPath = Files.createTempFile("model-spec", ".json", new FileAttribute[0]);
        Path path = Files.createTempFile("model-code", ".cpt", new FileAttribute[0]);
        Path dataTypePath = Files.createTempFile("model-type", ".json", new FileAttribute[0]);
        try {
            Formats writeFormat = DefaultFormats$.MODULE$.preservingEmptyValues();
            Files.write(specPath, Serialization$.MODULE$.write((Object)spec, writeFormat).getBytes(), new OpenOption[0]);
            Python$.MODULE$.execute(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(916).append("from pyspark.serializers import CloudPickleSerializer;\n           |import json\n           |import base64\n           |spec = json.load(open(\"").append(specPath).append("\", \"r\"))\n           |from rikai.spark.sql.codegen import command_from_spec\n           |serialize_func, func, deserialize_func, dataType = command_from_spec(\"").append(registryClassName).append("\", spec)\n           |pickle = CloudPickleSerializer()\n           |with open(\"").append(path).append("\", \"w\") as fobj:\n           |    json.dump({\n           |        \"func\": base64.b64encode(pickle.dumps((func.func, func.returnType))).decode('utf-8'),\n           |        \"serializer\": base64.b64encode(pickle.dumps((serialize_func.func, serialize_func.returnType))).decode('utf-8'),\n           |        \"deserializer\": base64.b64encode(pickle.dumps((deserialize_func.func, deserialize_func.returnType))).decode('utf-8'),\n           |    }, fobj)\n           |with open(\"").append(dataTypePath).append("\", \"w\") as fobj:\n           |    fobj.write(dataType.json())\n           |").toString())).stripMargin(), session);
            String cmdJson = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path)).asScala()).mkString("\n");
            Formats extractFormat = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
            ModelResolver.FuncDesc cmdMap = (ModelResolver.FuncDesc)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(cmdJson), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract(extractFormat, ManifestFactory$.MODULE$.classType(ModelResolver.FuncDesc.class));
            String dataTypeJson = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(dataTypePath)).asScala()).mkString("\n");
            DataType returnType = DataType$.MODULE$.fromJson(dataTypeJson);
            String suffix = Random$.MODULE$.alphanumeric().take(6).mkString().toLowerCase();
            String udfName = new StringBuilder(1).append(spec.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "model")).append("_").append(suffix).toString();
            String preUdfName = new StringBuilder(4).append(udfName).append("_pre").toString();
            String postUdfName = new StringBuilder(5).append(udfName).append("_post").toString();
            this.registerUdf(session, cmdMap.funcCmd(), udfName, (DataType)BinaryType$.MODULE$, PythonEvalType$.MODULE$.SQL_SCALAR_PANDAS_ITER_UDF());
            this.registerUdf(session, cmdMap.serializerFunc(), preUdfName, (DataType)BinaryType$.MODULE$, PythonEvalType$.MODULE$.SQL_BATCHED_UDF());
            this.registerUdf(session, cmdMap.deserializerFunc(), postUdfName, returnType, PythonEvalType$.MODULE$.SQL_BATCHED_UDF());
            sparkUDFModel = new SparkUDFModel((String)spec.name().get(), (String)spec.uri().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), udfName, spec.flavor(), (Option<String>)new Some((Object)preUdfName), (Option<String>)new Some((Object)postUdfName));
        }
        finally {
            Files.delete(path);
            Files.delete(specPath);
            Files.delete(dataTypePath);
        }
        return sparkUDFModel;
    }

    private ModelResolver$() {
        MODULE$ = this;
    }
}

