/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking;

import java.net.URI;
import org.mlflow.tracking.MlflowClient;
import org.mlflow.tracking.RiMlflowHttpCaller;
import org.mlflow.tracking.creds.BasicMlflowHostCreds;
import org.mlflow.tracking.creds.DatabricksConfigHostCredsProvider;
import org.mlflow.tracking.creds.DatabricksDynamicHostCredsProvider;
import org.mlflow.tracking.creds.HostCredsProviderChain;
import org.mlflow.tracking.creds.MlflowHostCredsProvider;

public class RikaiMlflowClient
extends MlflowClient {
    private final RiMlflowHttpCaller deleteHttpCaller;

    public RikaiMlflowClient(String string) {
        this(RikaiMlflowClient.getHostCredsProviderFromTrackingUri(string));
    }

    public RikaiMlflowClient(MlflowHostCredsProvider mlflowHostCredsProvider) {
        super(mlflowHostCredsProvider);
        this.deleteHttpCaller = new RiMlflowHttpCaller(mlflowHostCredsProvider);
    }

    public String sendDelete(String string, String string2) {
        return this.deleteHttpCaller.delete(string, string2);
    }

    private static MlflowHostCredsProvider getHostCredsProviderFromTrackingUri(String string) {
        MlflowHostCredsProvider mlflowHostCredsProvider;
        URI uRI = URI.create(string);
        if ("http".equals(uRI.getScheme()) || "https".equals(uRI.getScheme())) {
            mlflowHostCredsProvider = new BasicMlflowHostCreds(string);
        } else if (string.equals("databricks")) {
            DatabricksConfigHostCredsProvider databricksConfigHostCredsProvider = new DatabricksConfigHostCredsProvider();
            DatabricksDynamicHostCredsProvider databricksDynamicHostCredsProvider = DatabricksDynamicHostCredsProvider.createIfAvailable();
            mlflowHostCredsProvider = databricksDynamicHostCredsProvider != null ? new HostCredsProviderChain(databricksDynamicHostCredsProvider, databricksConfigHostCredsProvider) : databricksConfigHostCredsProvider;
        } else if ("databricks".equals(uRI.getScheme())) {
            mlflowHostCredsProvider = new DatabricksConfigHostCredsProvider(uRI.getHost());
        } else {
            if (uRI.getScheme() == null || "file".equals(uRI.getScheme())) {
                throw new IllegalArgumentException("Java Client currently does not support local tracking URIs. Please point to a Tracking Server.");
            }
            throw new IllegalArgumentException("Invalid tracking server uri: " + string);
        }
        return mlflowHostCredsProvider;
    }
}

