/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl;

import java.util.Locale;
import org.mlflow_project.apachehttp.HttpResponse;
import org.mlflow_project.apachehttp.HttpResponseFactory;
import org.mlflow_project.apachehttp.ProtocolVersion;
import org.mlflow_project.apachehttp.ReasonPhraseCatalog;
import org.mlflow_project.apachehttp.StatusLine;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.impl.EnglishReasonPhraseCatalog;
import org.mlflow_project.apachehttp.message.BasicHttpResponse;
import org.mlflow_project.apachehttp.message.BasicStatusLine;
import org.mlflow_project.apachehttp.protocol.HttpContext;
import org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseFactory
implements HttpResponseFactory {
    public static final DefaultHttpResponseFactory INSTANCE = new DefaultHttpResponseFactory();
    protected final ReasonPhraseCatalog reasonCatalog;

    public DefaultHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public HttpResponse newHttpResponse(ProtocolVersion ver, int status, HttpContext context) {
        Args.notNull(ver, "HTTP version");
        Locale loc = this.determineLocale(context);
        String reason = this.reasonCatalog.getReason(status, loc);
        BasicStatusLine statusline = new BasicStatusLine(ver, status, reason);
        return new BasicHttpResponse(statusline, this.reasonCatalog, loc);
    }

    @Override
    public HttpResponse newHttpResponse(StatusLine statusline, HttpContext context) {
        Args.notNull(statusline, "Status line");
        return new BasicHttpResponse(statusline, this.reasonCatalog, this.determineLocale(context));
    }

    protected Locale determineLocale(HttpContext context) {
        return Locale.getDefault();
    }
}

