/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rikai;

import org.apache.spark.sql.rikai.Box2dType;
import org.apache.spark.sql.rikai.Utils$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;

@SQLUserDefinedType(udt=Box2dType.class)
@ScalaSignature(bytes="\u0006\u0001U4A!\u0005\n\u0001;!Aq\u0005\u0001BC\u0002\u0013\u0005\u0001\u0006\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003*\u0011!i\u0003A!b\u0001\n\u0003A\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\t\u0011=\u0002!Q1A\u0005\u0002!B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tc\u0001\u0011)\u0019!C\u0001Q!A!\u0007\u0001B\u0001B\u0003%\u0011\u0006C\u00034\u0001\u0011\u0005A\u0007C\u0003<\u0001\u0011\u0005C\bC\u0003F\u0001\u0011\u0005a\tC\u0003M\u0001\u0011\u0005Q\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003S\u0001\u0011\u0005\u0001\u0006C\u0003T\u0001\u0011\u0005A\u000bC\u0003W\u0001\u0011\u0005sKA\u0003C_b\u0014DM\u0003\u0002\u0014)\u0005)!/[6bS*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\tyR%\u0003\u0002'A\ta1+\u001a:jC2L'0\u00192mK\u0006!\u00010\\5o+\u0005I\u0003CA\u0010+\u0013\tY\u0003E\u0001\u0004E_V\u0014G.Z\u0001\u0006q6Lg\u000eI\u0001\u0005s6Lg.A\u0003z[&t\u0007%\u0001\u0003y[\u0006D\u0018!\u0002=nCb\u0004\u0013\u0001B=nCb\fQ!_7bq\u0002\na\u0001P5oSRtD#B\u001b8qeR\u0004C\u0001\u001c\u0001\u001b\u0005\u0011\u0002\"B\u0014\n\u0001\u0004I\u0003\"B\u0017\n\u0001\u0004I\u0003\"B\u0018\n\u0001\u0004I\u0003\"B\u0019\n\u0001\u0004I\u0013AB3rk\u0006d7\u000f\u0006\u0002>\u0001B\u0011qDP\u0005\u0003\u007f\u0001\u0012qAQ8pY\u0016\fg\u000eC\u0003B\u0015\u0001\u0007!)A\u0001c!\ty2)\u0003\u0002EA\t\u0019\u0011I\\=\u0002\t\u0011\nW\u000e\u001d\u000b\u0003\u000f*\u00032a\b%6\u0013\tI\u0005E\u0001\u0004PaRLwN\u001c\u0005\u0006\u0017.\u0001\r!N\u0001\u0005i\"\fG/A\u0005j]R,'o]3diR\u0011qI\u0014\u0005\u0006\u00172\u0001\r!N\u0001\t_Z,'\u000f\\1qgR\u0011Q(\u0015\u0005\u0006\u00176\u0001\r!N\u0001\u0005CJ,\u0017-A\u0002j_V$\"!K+\t\u000b-{\u0001\u0019A\u001b\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u0017\t\u00033\u0002t!A\u00170\u0011\u0005m\u0003S\"\u0001/\u000b\u0005uc\u0012A\u0002\u001fs_>$h(\u0003\u0002`A\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\ty\u0006\u0005\u000b\u0003\u0001I\u001eD\u0007CA\u0010f\u0013\t1\u0007E\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKz\t\u0011\u0001\u000b\u0003\u0001UB\f\bCA6o\u001b\u0005a'BA7\u0015\u0003\u0015!\u0018\u0010]3t\u0013\tyGN\u0001\nT#2+6/\u001a:EK\u001aLg.\u001a3UsB,\u0017aA;ei\u000e\n!\u000f\u0005\u00027g&\u0011AO\u0005\u0002\n\u0005>D(\u0007\u001a+za\u0016\u0004")
public class Box2d
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final double xmin;
    private final double ymin;
    private final double xmax;
    private final double ymax;

    public double xmin() {
        return this.xmin;
    }

    public double ymin() {
        return this.ymin;
    }

    public double xmax() {
        return this.xmax;
    }

    public double ymax() {
        return this.ymax;
    }

    public boolean equals(Object b) {
        Object object = b;
        if (object instanceof Box2d) {
            Box2d box2d = (Box2d)object;
            return Utils$.MODULE$.approxEqual(this.xmin(), box2d.xmin()) && Utils$.MODULE$.approxEqual(this.ymin(), box2d.ymin()) && Utils$.MODULE$.approxEqual(this.xmax(), box2d.xmax()) && Utils$.MODULE$.approxEqual(this.ymax(), box2d.ymax());
        }
        return false;
    }

    public Option<Box2d> $amp(Box2d that) {
        return this.intersect(that);
    }

    public Option<Box2d> intersect(Box2d that) {
        if (this.xmin() > that.xmin()) {
            return that.intersect(this);
        }
        if (this.xmax() <= that.xmin()) {
            return None$.MODULE$;
        }
        if (this.ymin() > that.ymin()) {
            return that.intersect(this);
        }
        if (this.ymax() <= that.ymin()) {
            return None$.MODULE$;
        }
        double x$1 = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(this.xmin()), that.xmin());
        double x$2 = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(this.ymax()), that.ymax());
        double x$3 = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(this.ymin()), that.ymin());
        double x$4 = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(this.ymax()), that.ymax());
        return new Some((Object)new Box2d(x$1, x$3, x$2, x$4));
    }

    public boolean overlaps(Box2d that) {
        return this.$amp(that).isDefined();
    }

    public double area() {
        return (this.ymax() - this.ymin()) * (this.xmax() - this.xmin());
    }

    public double iou(Box2d that) {
        double interArea = BoxesRunTime.unboxToDouble((Object)this.$amp(that).map((Function1 & java.io.Serializable & Serializable)b -> BoxesRunTime.boxToDouble((double)((Box2d)b).area())).getOrElse((Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> 0.0));
        return interArea / (this.area() + that.area() - interArea);
    }

    public String toString() {
        Double arg$macro$1 = BoxesRunTime.boxToDouble((double)this.xmin());
        Double arg$macro$2 = BoxesRunTime.boxToDouble((double)this.ymin());
        Double arg$macro$3 = BoxesRunTime.boxToDouble((double)this.xmax());
        Double arg$macro$4 = BoxesRunTime.boxToDouble((double)this.ymax());
        return new StringOps("Box2d(xmin=%s, ymin=%s, xmax=%s, ymax=%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4}));
    }

    public Box2d(double xmin, double ymin, double xmax, double ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }
}

