/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow.tracking;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.mlflow.tracking.HttpDeleteWithBody;
import org.mlflow.tracking.MlflowClientException;
import org.mlflow.tracking.MlflowClientVersion;
import org.mlflow.tracking.MlflowHttpException;
import org.mlflow.tracking.creds.MlflowHostCreds;
import org.mlflow.tracking.creds.MlflowHostCredsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RiMlflowHttpCaller {
    private static final Logger logger = LoggerFactory.getLogger(RiMlflowHttpCaller.class);
    private static final String BASE_API_PATH = "api/2.0/preview/mlflow";
    protected HttpClient httpClient;
    private final MlflowHostCredsProvider hostCredsProvider;
    private final int maxRateLimitIntervalMillis;
    private final int rateLimitRetrySleepInitMillis;
    private final int maxRetryAttempts;

    RiMlflowHttpCaller(MlflowHostCredsProvider mlflowHostCredsProvider) {
        this(mlflowHostCredsProvider, 60000, 1000, 3);
    }

    RiMlflowHttpCaller(MlflowHostCredsProvider mlflowHostCredsProvider, int n, int n2, int n3) {
        this.hostCredsProvider = mlflowHostCredsProvider;
        this.maxRateLimitIntervalMillis = n;
        this.rateLimitRetrySleepInitMillis = n2;
        this.maxRetryAttempts = n3;
    }

    @VisibleForTesting
    RiMlflowHttpCaller(MlflowHostCredsProvider mlflowHostCredsProvider, int n, int n2, int n3, HttpClient httpClient) {
        this(mlflowHostCredsProvider, n, n2, n3);
        this.httpClient = httpClient;
    }

    private HttpResponse executeRequestWithRateLimitRetries(HttpRequestBase httpRequestBase) throws IOException {
        int n = this.maxRateLimitIntervalMillis;
        int n2 = this.rateLimitRetrySleepInitMillis;
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequestBase);
        while (httpResponse.getStatusLine().getStatusCode() == 429 && n > 0) {
            logger.warn("Request returned with status code 429 (Rate limit exceeded). Retrying after " + n2 + " milliseconds. Will continue to retry 429s for up to " + n + " milliseconds.");
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            n2 = Math.min(n -= n2, 2 * n2);
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequestBase);
        }
        this.checkError(httpResponse);
        return httpResponse;
    }

    private HttpResponse executeRequest(HttpRequestBase httpRequestBase) throws IOException {
        HttpResponse httpResponse = null;
        for (int i = this.maxRetryAttempts; i > 0; --i) {
            try {
                httpResponse = this.executeRequestWithRateLimitRetries(httpRequestBase);
                break;
            }
            catch (MlflowHttpException mlflowHttpException) {
                if (i > 0 && mlflowHttpException.getStatusCode() != 429) {
                    logger.warn("Request returned with status code {} (Rate limit exceeded). Retrying up to {} more times. Response body: {}", mlflowHttpException.getStatusCode(), i, mlflowHttpException.getBodyMessage());
                    continue;
                }
                throw mlflowHttpException;
            }
        }
        return httpResponse;
    }

    String delete(String string, String string2) {
        HttpDeleteWithBody httpDeleteWithBody = new HttpDeleteWithBody();
        return this.send(httpDeleteWithBody, string, string2);
    }

    private String send(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, String string, String string2) {
        this.fillRequestSettings((HttpRequestBase)httpEntityEnclosingRequestBase, string);
        httpEntityEnclosingRequestBase.setEntity((HttpEntity)new StringEntity(string2, StandardCharsets.UTF_8));
        httpEntityEnclosingRequestBase.setHeader("Content-Type", "application/json");
        try {
            HttpResponse httpResponse = this.executeRequest((HttpRequestBase)httpEntityEnclosingRequestBase);
            String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            logger.debug("Response: " + string3);
            return string3;
        }
        catch (IOException iOException) {
            throw new MlflowClientException(iOException);
        }
    }

    private void checkError(HttpResponse httpResponse) throws MlflowClientException, IOException {
        int n = httpResponse.getStatusLine().getStatusCode();
        String string = httpResponse.getStatusLine().getReasonPhrase();
        if (this.isError(n)) {
            String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (n >= 400 && n <= 499) {
                throw new MlflowHttpException(n, string, string2);
            }
            if (n >= 500 && n <= 599) {
                throw new MlflowHttpException(n, string, string2);
            }
            throw new MlflowHttpException(n, string, string2);
        }
    }

    private void fillRequestSettings(HttpRequestBase httpRequestBase, String string) {
        String string2;
        MlflowHostCreds mlflowHostCreds = this.hostCredsProvider.getHostCreds();
        this.createHttpClientIfNecessary(mlflowHostCreds.shouldIgnoreTlsVerification());
        String string3 = mlflowHostCreds.getHost() + "/" + BASE_API_PATH + "/" + string;
        httpRequestBase.setURI(URI.create(string3));
        String string4 = mlflowHostCreds.getUsername();
        String string5 = mlflowHostCreds.getPassword();
        String string6 = mlflowHostCreds.getToken();
        if (string4 != null && string5 != null) {
            string2 = Base64.getEncoder().encodeToString((string4 + ":" + string5).getBytes(StandardCharsets.UTF_8));
            httpRequestBase.addHeader("Authorization", "Basic " + string2);
        } else if (string6 != null) {
            httpRequestBase.addHeader("Authorization", "Bearer " + string6);
        }
        string2 = "mlflow-java-client";
        String string7 = MlflowClientVersion.getClientVersion();
        if (!string7.isEmpty()) {
            string2 = string2 + "/" + string7;
        }
        httpRequestBase.addHeader("User-Agent", string2);
    }

    private boolean isError(int n) {
        return n < 200 || n > 399;
    }

    private void createHttpClientIfNecessary(boolean bl) {
        if (this.httpClient != null) {
            return;
        }
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (bl) {
            try {
                SSLContextBuilder sSLContextBuilder = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory sSLConnectionSocketFactory = new SSLConnectionSocketFactory(sSLContextBuilder.build(), (HostnameVerifier)new NoopHostnameVerifier());
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sSLConnectionSocketFactory);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
                logger.warn("Could not set noTlsVerify to true, verification will remain", generalSecurityException);
            }
        }
        this.httpClient = httpClientBuilder.build();
    }
}

