/*
 * Decompiled with CFR 0.152.
 */
package ai.eto.rikai.sql.model;

import ai.eto.rikai.sql.model.Model;
import ai.eto.rikai.sql.model.ModelNotFoundException;
import ai.eto.rikai.sql.model.ModelRegistryAlreadyExistException;
import ai.eto.rikai.sql.model.ModelResolveException;
import ai.eto.rikai.sql.model.ModelSpec;
import ai.eto.rikai.sql.model.Registry;
import ai.eto.rikai.sql.model.dummy.DummyRegistry$;
import java.io.Serializable;
import java.net.URI;
import org.apache.http.client.utils.URIUtils;
import org.apache.log4j.Logger;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapFactoryDefaults;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Registry$ {
    public static final Registry$ MODULE$ = new Registry$();
    private static final String REGISTRY_IMPL_PREFIX = "spark.rikai.sql.ml.registry.";
    private static final String REGISTRY_IMPL_SUFFIX = ".impl";
    private static final String DEFAULT_URI_ROOT_KEY = "spark.rikai.sql.ml.registry.uri.root";
    private static final Map<String, String> DEFAULT_REGISTRIES = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.rikai.sql.ml.registry.file.impl"), (Object)"ai.eto.rikai.sql.model.fs.FileSystemRegistry"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.rikai.sql.ml.registry.mlflow.impl"), (Object)"ai.eto.rikai.sql.model.mlflow.MlflowRegistry")}));
    private static final Logger logger = Logger.getLogger(MODULE$.getClass());
    private static Map<String, Registry> registryMap = Predef$.MODULE$.Map().empty();
    private static URI defaultUriRoot = new URI("file:/");

    public String REGISTRY_IMPL_PREFIX() {
        return REGISTRY_IMPL_PREFIX;
    }

    public String REGISTRY_IMPL_SUFFIX() {
        return REGISTRY_IMPL_SUFFIX;
    }

    public String DEFAULT_URI_ROOT_KEY() {
        return DEFAULT_URI_ROOT_KEY;
    }

    public Map<String, String> DEFAULT_REGISTRIES() {
        return DEFAULT_REGISTRIES;
    }

    private Logger logger() {
        return logger;
    }

    private Map<String, Registry> registryMap() {
        return registryMap;
    }

    private void registryMap_$eq(Map<String, Registry> x$1) {
        registryMap = x$1;
    }

    private URI defaultUriRoot() {
        return defaultUriRoot;
    }

    private void defaultUriRoot_$eq(URI x$1) {
        defaultUriRoot = x$1;
    }

    public void registerAll(Map<String, String> conf) {
        ((MapFactoryDefaults)this.DEFAULT_REGISTRIES().$plus$plus(conf)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Registry$.$anonfun$registerAll$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            Registry$.$anonfun$registerAll$2(conf, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyScheme(String scheme) throws ModelResolveException {
        String schemeRegex = "[a-zA-Z][\\w\\+]{0,255}";
        if (scheme != null && !scheme.matches(schemeRegex)) {
            throw new ModelResolveException(new StringBuilder(27).append("Scheme '").append(scheme).append("' does not match '").append(schemeRegex).append("'").toString());
        }
    }

    public Registry getRegistry(Option<String> uriOption) throws ModelResolveException {
        Registry registry;
        Option<String> option = uriOption;
        if (option instanceof Some) {
            Registry registry2;
            Some some = (Some)option;
            String uri = (String)some.value();
            URI parsedNormalizedUri = this.normalize_uri(uri);
            String scheme = parsedNormalizedUri.getScheme();
            Option option2 = this.registryMap().get((Object)scheme);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new ModelResolveException(new StringBuilder(41).append("Model registry scheme '").append(scheme).append("' is not supported").toString());
                }
                throw new MatchError((Object)option2);
            }
            Some some2 = (Some)option2;
            Registry registry3 = registry2 = (Registry)some2.value();
            registry = registry3;
        } else if (None$.MODULE$.equals(option)) {
            registry = DummyRegistry$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return registry;
    }

    public URI normalize_uri(String uri) {
        String string;
        URI parsedUri = new URI(uri);
        String string2 = parsedUri.getScheme();
        URI uRI = string2 != null && !(string = string2).isEmpty() ? parsedUri : URIUtils.resolve((URI)this.defaultUriRoot(), (String)uri);
        return uRI;
    }

    public Model resolve(SparkSession session, ModelSpec spec) throws ModelResolveException, ModelNotFoundException {
        return this.getRegistry(spec.uri()).resolve(session, spec);
    }

    public void reset() {
        this.registryMap_$eq((Map<String, Registry>)Predef$.MODULE$.Map().empty());
    }

    public static final /* synthetic */ boolean $anonfun$registerAll$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$registerAll$2(Map conf$1, Tuple2 x$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            String string = key;
            String string2 = MODULE$.DEFAULT_URI_ROOT_KEY();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Success success;
                URI uri;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> new URI(value));
                if (!(try_ instanceof Success) || (uri = (URI)(success = (Success)try_).value()).getScheme() == null || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(uri.getScheme()))) {
                    throw new IllegalArgumentException(new StringBuilder(65).append("Default URI root ").append(value).append(" is not well-formed or does not specify a scheme").toString());
                }
                MODULE$.defaultUriRoot_$eq(uri);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
            } else if (key.startsWith(MODULE$.REGISTRY_IMPL_PREFIX()) && key.endsWith(MODULE$.REGISTRY_IMPL_SUFFIX())) {
                String scheme = key.substring(MODULE$.REGISTRY_IMPL_PREFIX().length(), key.length() - MODULE$.REGISTRY_IMPL_SUFFIX().length());
                MODULE$.verifyScheme(scheme);
                if (MODULE$.registryMap().contains((Object)scheme)) {
                    throw new ModelRegistryAlreadyExistException(scheme != null ? new StringBuilder(22).append("ModelRegistry(").append(scheme).append(") exists").toString() : "Default ModelRegistry exists");
                }
                MODULE$.registryMap_$eq((Map<String, Registry>)((Map)MODULE$.registryMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)scheme), (Object)((Registry)Class.forName(value).getDeclaredConstructor(Map.class).newInstance(conf$1))))));
                MODULE$.logger().debug((Object)new StringBuilder(31).append("Model Registry ").append(scheme).append(" registered to: ").append(value).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    private Registry$() {
    }
}

