/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rikai;

import java.io.Serializable;
import org.apache.spark.sql.rikai.Box2dType;
import org.apache.spark.sql.rikai.Utils$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@SQLUserDefinedType(udt=Box2dType.class)
@ScalaSignature(bytes="\u0006\u0005m4A!\u0005\n\u0001;!A\u0001\u0007\u0001BC\u0002\u0013\u0005\u0011\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00033\u0011!1\u0004A!b\u0001\n\u0003\t\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011a\u0002!Q1A\u0005\u0002EB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tu\u0001\u0011)\u0019!C\u0001c!A1\b\u0001B\u0001B\u0003%!\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003E\u0001\u0011\u0005S\tC\u0003O\u0001\u0011\u0005q\nC\u0003V\u0001\u0011\u0005a\u000bC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003\\\u0001\u0011\u0005\u0011\u0007C\u0003]\u0001\u0011\u0005Q\fC\u0003`\u0001\u0011\u0005\u0003MA\u0003C_b\u0014DM\u0003\u0002\u0014)\u0005)!/[6bS*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\b\u0013\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)SF\u0004\u0002'W9\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006H\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!\u0001\f\u0011\u0002\u000fA\f7m[1hK&\u0011af\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003Y\u0001\nA\u0001_7j]V\t!\u0007\u0005\u0002 g%\u0011A\u0007\t\u0002\u0007\t>,(\r\\3\u0002\u000bal\u0017N\u001c\u0011\u0002\tel\u0017N\\\u0001\u0006s6Lg\u000eI\u0001\u0005q6\f\u00070A\u0003y[\u0006D\b%\u0001\u0003z[\u0006D\u0018!B=nCb\u0004\u0013A\u0002\u001fj]&$h\bF\u0003?\u0001\u0006\u00135\t\u0005\u0002@\u00015\t!\u0003C\u00031\u0013\u0001\u0007!\u0007C\u00037\u0013\u0001\u0007!\u0007C\u00039\u0013\u0001\u0007!\u0007C\u0003;\u0013\u0001\u0007!'\u0001\u0004fcV\fGn\u001d\u000b\u0003\r&\u0003\"aH$\n\u0005!\u0003#a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0015*\u0001\raS\u0001\u0002EB\u0011q\u0004T\u0005\u0003\u001b\u0002\u00121!\u00118z\u0003\u0011!\u0013-\u001c9\u0015\u0005A\u001b\u0006cA\u0010R}%\u0011!\u000b\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000bQ[\u0001\u0019\u0001 \u0002\tQD\u0017\r^\u0001\nS:$XM]:fGR$\"\u0001U,\t\u000bQc\u0001\u0019\u0001 \u0002\u0011=4XM\u001d7baN$\"A\u0012.\t\u000bQk\u0001\u0019\u0001 \u0002\t\u0005\u0014X-Y\u0001\u0004S>,HC\u0001\u001a_\u0011\u0015!v\u00021\u0001?\u0003!!xn\u0015;sS:<G#A1\u0011\u0005\t4gBA2e!\t9\u0003%\u0003\u0002fA\u00051\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)\u0007\u0005\u000b\u0003\u0001U6t\u0007CA\u0010l\u0013\ta\u0007E\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKz\t\u0011\u0001\u000b\u0003\u0001aZ<\bCA9u\u001b\u0005\u0011(BA:\u0015\u0003\u0015!\u0018\u0010]3t\u0013\t)(O\u0001\nT#2+6/\u001a:EK\u001aLg.\u001a3UsB,\u0017aA;ei\u000e\n\u0001\u0010\u0005\u0002@s&\u0011!P\u0005\u0002\n\u0005>D(\u0007\u001a+za\u0016\u0004")
public class Box2d
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double xmin;
    private final double ymin;
    private final double xmax;
    private final double ymax;

    public double xmin() {
        return this.xmin;
    }

    public double ymin() {
        return this.ymin;
    }

    public double xmax() {
        return this.xmax;
    }

    public double ymax() {
        return this.ymax;
    }

    public boolean equals(Object b) {
        boolean bl;
        Object object = b;
        if (object instanceof Box2d) {
            Box2d box2d = (Box2d)object;
            bl = Utils$.MODULE$.approxEqual(this.xmin(), box2d.xmin()) && Utils$.MODULE$.approxEqual(this.ymin(), box2d.ymin()) && Utils$.MODULE$.approxEqual(this.xmax(), box2d.xmax()) && Utils$.MODULE$.approxEqual(this.ymax(), box2d.ymax());
        } else {
            bl = false;
        }
        return bl;
    }

    public Option<Box2d> $amp(Box2d that) {
        return this.intersect(that);
    }

    public Option<Box2d> intersect(Box2d that) {
        if (this.xmin() > that.xmin()) {
            return that.intersect(this);
        }
        if (this.xmax() <= that.xmin()) {
            return None$.MODULE$;
        }
        if (this.ymin() > that.ymin()) {
            return that.intersect(this);
        }
        if (this.ymax() <= that.ymin()) {
            return None$.MODULE$;
        }
        double x$1 = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(this.xmin()), that.xmin());
        double x$2 = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(this.ymax()), that.ymax());
        double x$3 = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(this.ymin()), that.ymin());
        double x$4 = RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(this.ymax()), that.ymax());
        return new Some((Object)new Box2d(x$1, x$3, x$2, x$4));
    }

    public boolean overlaps(Box2d that) {
        return this.$amp(that).isDefined();
    }

    public double area() {
        return (this.ymax() - this.ymin()) * (this.xmax() - this.xmin());
    }

    public double iou(Box2d that) {
        double interArea = BoxesRunTime.unboxToDouble((Object)this.$amp(that).map((Function1 & Serializable)b -> BoxesRunTime.boxToDouble((double)((Box2d)b).area())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        return interArea / (this.area() + that.area() - interArea);
    }

    public String toString() {
        Double arg$macro$1 = BoxesRunTime.boxToDouble((double)this.xmin());
        Double arg$macro$2 = BoxesRunTime.boxToDouble((double)this.ymin());
        Double arg$macro$3 = BoxesRunTime.boxToDouble((double)this.xmax());
        Double arg$macro$4 = BoxesRunTime.boxToDouble((double)this.ymax());
        return StringOps$.MODULE$.format$extension("Box2d(xmin=%s, ymin=%s, xmax=%s, ymax=%s)", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4}));
    }

    public Box2d(double xmin, double ymin, double xmax, double ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }
}

