package ai.fal.falclient

import UntypedRealtimeConnection
import WebSocketConnection
import com.google.gson.Gson
import kotlinx.coroutines.CompletableDeferred
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import kotlinx.coroutines.runBlocking
import throttle

fun main() = runBlocking {
    val app = "110602490-lcm-sd15-i2i"
    val authKey = "72bb1eb9-4cfc-4e12-8ac8-4248459e4129:5949aeaafaba9d4d4936c1023db4b612"
    val onMessage: (String) -> Unit = { message ->
        println("Received message: $message")
    }

    val onError: (Throwable) -> Unit = { error ->
        println("Error occurred: ${error.message}")
    }

    val webSocketConnection = WebSocketConnection(app, onMessage, onError)

    // Connect to the server
    webSocketConnection.connect(authKey)

    val inputMap = hashMapOf(
        "prompt" to "an island near sea, with seagulls",
        "image_url" to "https://storage.googleapis.com/falserverless/model_tests/lcm/source_image.png",
        "seed" to 6252023,
        "sync_mode" to 1,
        "strength" to 0.8,
        "num_inference_steps" to 4,
    )

    println("Is connection closed? ${!webSocketConnection.isConnected()}")

    while(!webSocketConnection.isConnected()) {
        delay(100)
    }

    println("Is connection closed? ${!webSocketConnection.isConnected()}")

    webSocketConnection.send(Gson().toJson(inputMap))

    delay(1000)
    // Close the connection
    webSocketConnection.close()

    println("Is connection closed? ${!webSocketConnection.isConnected()}")
}

/*
fun main() {
    // Initialize FalClient with your credentials
    val authKey = "72bb1eb9-4cfc-4e12-8ac8-4248459e4129:5949aeaafaba9d4d4936c1023db4b612"
    val falClient = FalClient(ClientConfig(credentials = authKey))

    // Define the input parameters for the function
    val inputParams = hashMapOf(
        "prompt" to "a cute shih-tzu puppy",
        "model_name" to "stabilityai/stable-diffusion-xl-base-1.0",
        "image_size" to "square_hd"
    )

    // Run the function and print the result
    try {
        println("WHY")
        val result = falClient.run("110602490-lora", inputParams)
        println(result)
    } catch (e: Error) {
        println("Error running the function: ${e.message}")
    }

    // Subscribe to the function and print the updates
    try {
        val subscribeResult = falClient.subscribe("110602490-lora", inputParams, 1000L, 30000L, true) { update ->
            println("Update: $update")
        }
        println("Final result: $subscribeResult")
    } catch (e: Error) {
        println("Error subscribing to the function: ${e.message}")
    }


}
*/
