/*
 * Decompiled with CFR 0.152.
 */
package ai.foremast.metrics.k8s.starter;

import ai.foremast.metrics.k8s.starter.CommonMetricsFilter;
import ai.foremast.metrics.k8s.starter.K8sMetricsProperties;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.spring.autoconfigure.MeterRegistryCustomizer;
import io.micrometer.spring.autoconfigure.MetricsProperties;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={K8sMetricsProperties.class, MetricsProperties.class})
public class K8sMetricsAutoConfiguration
implements MeterRegistryCustomizer {
    @Autowired
    K8sMetricsProperties metricsProperties;
    @Autowired
    ConfigurableApplicationContext appContext;
    private static final String HTTP_SERVER_REQUESTS = "http.server.requests";

    @Bean
    public CommonMetricsFilter commonMetricsFilter(MetricsProperties properties) {
        return new CommonMetricsFilter(this.metricsProperties, properties);
    }

    public void customize(MeterRegistry registry) {
        String statuses;
        String commonTagNameValuePair = this.metricsProperties.getCommonTagNameValuePairs();
        if (commonTagNameValuePair != null && !commonTagNameValuePair.isEmpty()) {
            String[] pairs;
            block0: for (String p : pairs = commonTagNameValuePair.split(",")) {
                String[] nameAndValue = p.split(":");
                if (nameAndValue == null || nameAndValue.length != 2) {
                    throw new IllegalStateException("Invalid common tag name value pair:" + p);
                }
                String valuePattern = nameAndValue[1];
                int sepIndex = valuePattern.indexOf(124);
                String[] patterns = null;
                patterns = sepIndex > 0 ? valuePattern.split(Pattern.quote("|")) : new String[]{valuePattern};
                for (int i = 0; i < patterns.length; ++i) {
                    String value = null;
                    if (patterns[i].startsWith("ENV.")) {
                        value = System.getenv(patterns[i].substring(4));
                    } else {
                        value = System.getProperty(patterns[i]);
                        if ((value == null || value.isEmpty()) && this.appContext != null) {
                            value = this.appContext.getEnvironment().getProperty(patterns[i]);
                        }
                    }
                    if (value == null || value.isEmpty()) continue;
                    registry.config().commonTags(new String[]{nameAndValue[0], value});
                    continue block0;
                }
            }
        }
        if ((statuses = this.metricsProperties.getInitializeForStatuses()) != null || !statuses.isEmpty()) {
            String[] statusCodes;
            for (String code : statusCodes = statuses.split(",")) {
                if (this.metricsProperties.hasCaller()) {
                    registry.timer(HTTP_SERVER_REQUESTS, new String[]{"exception", "None", "method", "GET", "status", code, "uri", "/**", "caller", "*"});
                    continue;
                }
                registry.timer(HTTP_SERVER_REQUESTS, new String[]{"exception", "None", "method", "GET", "status", code, "uri", "/**"});
            }
        }
    }
}

