/*
 * Decompiled with CFR 0.152.
 */
package ai.fxn.fxn.gradle;

import ai.fxn.fxn.gradle.CachedPrediction;
import ai.fxn.fxn.gradle.CreatePredictionInput;
import ai.fxn.fxn.gradle.ErrorResponse;
import ai.fxn.fxn.gradle.ErrorResponseItem;
import ai.fxn.fxn.gradle.FunctionEmbed;
import ai.fxn.fxn.gradle.FunctionExtension;
import ai.fxn.fxn.gradle.FunctionGradlePlugin;
import ai.fxn.fxn.gradle.Prediction;
import ai.fxn.fxn.gradle.PredictionCache;
import ai.fxn.fxn.gradle.PredictionResource;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.internal.tasks.MergeNativeLibsTask;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.Rfc3339DateJsonAdapter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J0\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lai/fxn/fxn/gradle/FunctionGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "createPrediction", "Lai/fxn/fxn/gradle/Prediction;", "tag", "", "clientId", "apiUrl", "accessKey", "moshi", "Lcom/squareup/moshi/Moshi;", "downloadResource", "url", "destination", "Ljava/io/File;", "getAbis", "", "android", "Lcom/android/build/gradle/AppExtension;", "fxn-gradle"})
public class FunctionGradlePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FunctionExtension extension = (FunctionExtension)project.getExtensions().create("fxn", FunctionExtension.class, new Object[0]);
        Object object = project.getExtensions().findByName("android");
        AppExtension appExtension = object instanceof AppExtension ? (AppExtension)object : null;
        if (appExtension == null) {
            throw new IllegalStateException("Android plugin is not applied to the project '" + project.getName() + "'.");
        }
        AppExtension androidExtension = appExtension;
        project.afterEvaluate(arg_0 -> FunctionGradlePlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(extension, this, androidExtension, project){
            final /* synthetic */ FunctionExtension $extension;
            final /* synthetic */ FunctionGradlePlugin this$0;
            final /* synthetic */ AppExtension $androidExtension;
            final /* synthetic */ Project $project;
            {
                this.$extension = $extension;
                this.this$0 = $receiver;
                this.$androidExtension = $androidExtension;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Project it) {
                List embeds = (List)this.$extension.getEmbeds().get();
                List abis = FunctionGradlePlugin.access$getAbis(this.this$0, this.$androidExtension);
                Moshi moshi = new Moshi.Builder().add((Type)((Object)Date.class), (JsonAdapter)new Rfc3339DateJsonAdapter()).build();
                this.$androidExtension.getApplicationVariants().all(arg_0 -> apply.1.invoke$lambda$0((Function1)new Function1<ApplicationVariant, Unit>(this.$androidExtension, this.$project, this.$extension, (List<FunctionEmbed>)embeds, moshi, (List<String>)abis, this.this$0){
                    final /* synthetic */ AppExtension $androidExtension;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ FunctionExtension $extension;
                    final /* synthetic */ List<FunctionEmbed> $embeds;
                    final /* synthetic */ Moshi $moshi;
                    final /* synthetic */ List<String> $abis;
                    final /* synthetic */ FunctionGradlePlugin this$0;
                    {
                        this.$androidExtension = $androidExtension;
                        this.$project = $project;
                        this.$extension = $extension;
                        this.$embeds = $embeds;
                        this.$moshi = $moshi;
                        this.$abis = $abis;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(ApplicationVariant variant) {
                        String string = variant.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String variantName = StringsKt.capitalize((String)string);
                        AndroidSourceSet sourceSet = (AndroidSourceSet)this.$androidExtension.getSourceSets().getByName(variant.getName());
                        Task task = this.$project.getTasks().getByName("merge" + variantName + "NativeLibs");
                        Intrinsics.checkNotNull((Object)task, (String)"null cannot be cast to non-null type com.android.build.gradle.internal.tasks.MergeNativeLibsTask");
                        MergeNativeLibsTask mergeNativeLibsTask = (MergeNativeLibsTask)task;
                        Task mergeAssetsTask = this.$project.getTasks().getByName("merge" + variantName + "Assets");
                        Directory workDir = ((Directory)this.$project.getLayout().getBuildDirectory().get()).dir("generated/fxn/" + variant.getName());
                        Directory assetDir = workDir.dir("assets");
                        Directory resourceDir = workDir.dir("resources");
                        Directory libDir = resourceDir.dir("lib");
                        if (assetDir.getAsFile().exists()) {
                            File file = assetDir.getAsFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                            FilesKt.deleteRecursively((File)file);
                        }
                        if (libDir.getAsFile().exists()) {
                            File file = libDir.getAsFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                            FilesKt.deleteRecursively((File)file);
                        }
                        assetDir.getAsFile().mkdirs();
                        libDir.getAsFile().mkdirs();
                        AndroidSourceDirectorySet androidSourceDirectorySet = sourceSet.getAssets();
                        Intrinsics.checkNotNull((Object)assetDir);
                        androidSourceDirectorySet.srcDir((Object)assetDir);
                        AndroidSourceDirectorySet androidSourceDirectorySet2 = sourceSet.getJniLibs();
                        Intrinsics.checkNotNull((Object)libDir);
                        androidSourceDirectorySet2.srcDir((Object)libDir);
                        TaskProvider embedPredictorsTask2 = this.$project.getTasks().register("fxnEmbedPredictors" + variantName, arg_0 -> apply.1.invoke$lambda$0((Function1)new Function1<Task, Unit>(this.$extension, this.$embeds, this.$moshi, assetDir, this.$abis, libDir, this.this$0){
                            final /* synthetic */ FunctionExtension $extension;
                            final /* synthetic */ List<FunctionEmbed> $embeds;
                            final /* synthetic */ Moshi $moshi;
                            final /* synthetic */ Directory $assetDir;
                            final /* synthetic */ List<String> $abis;
                            final /* synthetic */ Directory $libDir;
                            final /* synthetic */ FunctionGradlePlugin this$0;
                            {
                                this.$extension = $extension;
                                this.$embeds = $embeds;
                                this.$moshi = $moshi;
                                this.$assetDir = $assetDir;
                                this.$abis = $abis;
                                this.$libDir = $libDir;
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(Task it) {
                                it.setGroup("Function");
                                it.setDescription("Embed predictors into the app bundle.");
                                it.doLast(arg_0 -> apply.embedPredictorsTask.1.invoke$lambda$0((Function1)new Function1<Task, Unit>(this.$extension, this.$embeds, this.$moshi, this.$assetDir, this.$abis, this.$libDir, this.this$0){
                                    final /* synthetic */ FunctionExtension $extension;
                                    final /* synthetic */ List<FunctionEmbed> $embeds;
                                    final /* synthetic */ Moshi $moshi;
                                    final /* synthetic */ Directory $assetDir;
                                    final /* synthetic */ List<String> $abis;
                                    final /* synthetic */ Directory $libDir;
                                    final /* synthetic */ FunctionGradlePlugin this$0;
                                    {
                                        this.$extension = $extension;
                                        this.$embeds = $embeds;
                                        this.$moshi = $moshi;
                                        this.$assetDir = $assetDir;
                                        this.$abis = $abis;
                                        this.$libDir = $libDir;
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final void invoke(Task it) {
                                        void $this$forEach$iv;
                                        String string;
                                        String accessKey;
                                        String string2 = (String)this.$extension.getAccessKey().getOrNull();
                                        if (string2 == null) {
                                            string2 = accessKey = "";
                                        }
                                        if ((string = (String)this.$extension.getApiUrl().getOrNull()) == null) {
                                            string = "https://api.fxn.ai/v1";
                                        }
                                        String apiUrl = string;
                                        List predictions = new ArrayList<E>();
                                        List<FunctionEmbed> list = this.$embeds;
                                        Intrinsics.checkNotNullExpressionValue(list, (String)"$embeds");
                                        Iterable iterable = list;
                                        List<String> list2 = this.$abis;
                                        Directory directory = this.$libDir;
                                        FunctionGradlePlugin functionGradlePlugin = this.this$0;
                                        Moshi moshi = this.$moshi;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            FunctionEmbed embed = (FunctionEmbed)element$iv;
                                            boolean bl = false;
                                            Iterable $this$forEach$iv2 = list2;
                                            boolean $i$f$forEach2 = false;
                                            for (T element$iv2 : $this$forEach$iv2) {
                                                String string3;
                                                String abi = (String)element$iv2;
                                                boolean bl2 = false;
                                                Directory abiDir = directory.dir(abi);
                                                String string4 = embed.getTag();
                                                String string5 = "android-" + abi;
                                                String string6 = embed.getApiUrl();
                                                if (string6 == null) {
                                                    string6 = apiUrl;
                                                }
                                                if ((string3 = embed.getAccessKey()) == null) {
                                                    string3 = accessKey;
                                                }
                                                Intrinsics.checkNotNull((Object)moshi);
                                                Prediction prediction = FunctionGradlePlugin.access$createPrediction(functionGradlePlugin, string4, string5, string6, string3, moshi);
                                                Iterable $this$forEach$iv3 = prediction.getResources();
                                                boolean $i$f$forEach3 = false;
                                                for (T element$iv3 : $this$forEach$iv3) {
                                                    PredictionResource resource = (PredictionResource)element$iv3;
                                                    boolean bl3 = false;
                                                    if (!Intrinsics.areEqual((Object)resource.getType(), (Object)"dso")) continue;
                                                    String string7 = new URL(resource.getUrl()).getPath();
                                                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getPath(...)");
                                                    String hash = StringsKt.substringAfterLast$default((String)string7, (String)"/", null, (int)2, null);
                                                    Object object = resource.getName();
                                                    if (object == null) {
                                                        object = hash + ".so";
                                                    }
                                                    String name = object;
                                                    String string8 = resource.getUrl();
                                                    File file = abiDir.file(name).getAsFile();
                                                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
                                                    FunctionGradlePlugin.access$downloadResource(functionGradlePlugin, string8, file);
                                                }
                                                CachedPrediction cachedPrediction = new CachedPrediction(abi, prediction);
                                                predictions.add(cachedPrediction);
                                            }
                                        }
                                        PredictionCache cache = new PredictionCache(predictions);
                                        JsonAdapter cacheAdapter = this.$moshi.adapter(PredictionCache.class).indent("  ");
                                        String cacheJson = cacheAdapter.toJson((Object)cache);
                                        File cacheFile = this.$assetDir.file("fxn.resolved").getAsFile();
                                        Intrinsics.checkNotNull((Object)cacheFile);
                                        Intrinsics.checkNotNull((Object)cacheJson);
                                        FilesKt.writeText$default((File)cacheFile, (String)cacheJson, null, (int)2, null);
                                    }
                                }, arg_0));
                            }

                            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                $tmp0.invoke(p0);
                            }
                        }, arg_0));
                        Object[] objectArray = new Object[]{embedPredictorsTask2};
                        mergeNativeLibsTask.dependsOn(objectArray);
                        objectArray = new Object[]{embedPredictorsTask2};
                        mergeAssetsTask.dependsOn(objectArray);
                    }

                    private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                        $tmp0.invoke(p0);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Prediction createPrediction(String tag, String clientId, String apiUrl, String accessKey, Moshi moshi) {
        OkHttpClient client = new OkHttpClient();
        JsonAdapter jsonAdapter = moshi.adapter(CreatePredictionInput.class);
        JsonAdapter responseAdapter = moshi.adapter(Prediction.class);
        JsonAdapter errorAdapter = moshi.adapter(ErrorResponse.class);
        CreatePredictionInput requestBody = new CreatePredictionInput(tag, clientId);
        String requestBodyJson = jsonAdapter.toJson((Object)requestBody);
        MediaType mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        Intrinsics.checkNotNull((Object)requestBodyJson);
        RequestBody body = RequestBody.Companion.create(mediaType, requestBodyJson);
        Request request = new Request.Builder().url(apiUrl + "/predictions").addHeader("Authorization", "Bearer " + accessKey).post(body).build();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new Exception("Function failed to embed `" + tag + "` predictor with status code: " + response.code());
            }
            Object responseBody = object;
            if (response.isSuccessful()) {
                Object object2 = responseAdapter.fromJson((String)responseBody);
                Intrinsics.checkNotNull((Object)object2);
                Prediction prediction = (Prediction)object2;
                return prediction;
            }
            try {
                ErrorResponseItem[] errors = (ErrorResponseItem[])errorAdapter.fromJson((String)responseBody);
                Object object3 = errors;
                if (errors == null || (object3 = ((ErrorResponse)object3).getErrors()) == null || (object3 = object3[0]) == null || (object3 = ((ErrorResponseItem)object3).getMessage()) == null) {
                    object3 = "unknown error";
                }
                Object error = object3;
                throw new Exception("Function failed to embed `" + tag + "` predictor with error: " + (String)error);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadResource(String url, File destination) {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).build();
        destination.getParentFile().mkdirs();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            long l;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new Exception("Function failed to download prediction resource from " + url + ": " + response);
            }
            Object object = response.body();
            if (object != null && (object = object.byteStream()) != null) {
                Closeable closeable2 = (Closeable)object;
                Throwable throwable2 = null;
                try {
                    long l2;
                    InputStream input = (InputStream)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = new FileOutputStream(destination);
                    Throwable throwable3 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable3;
                        boolean bl3 = false;
                        l2 = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    l = l2;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            throw new Exception("Empty response body when downloading " + url);
            long l3 = l;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final List<String> getAbis(AppExtension android) {
        Object[] objectArray = new String[]{"armeabi-v7a", "arm64-v8a", "x86_64"};
        List DEFAULT_ABIS = CollectionsKt.listOf((Object[])objectArray);
        Set set = android.getDefaultConfig().getNdk().getAbiFilters();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-abiFilters>(...)");
        Set abiFilters = set;
        return !((Collection)abiFilters).isEmpty() ? CollectionsKt.toList((Iterable)abiFilters) : DEFAULT_ABIS;
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getAbis(FunctionGradlePlugin $this, AppExtension android) {
        return $this.getAbis(android);
    }

    public static final /* synthetic */ void access$downloadResource(FunctionGradlePlugin $this, String url, File destination) {
        $this.downloadResource(url, destination);
    }

    public static final /* synthetic */ Prediction access$createPrediction(FunctionGradlePlugin $this, String tag, String clientId, String apiUrl, String accessKey, Moshi moshi) {
        return $this.createPrediction(tag, clientId, apiUrl, accessKey, moshi);
    }
}

