/*
 * Decompiled with CFR 0.152.
 */
package ai.fxn.fxn.gradle;

import ai.fxn.fxn.gradle.CreatePredictionInput;
import ai.fxn.fxn.gradle.ErrorResponse;
import ai.fxn.fxn.gradle.ErrorResponseItem;
import ai.fxn.fxn.gradle.FunctionEmbed;
import ai.fxn.fxn.gradle.FunctionExtension;
import ai.fxn.fxn.gradle.Prediction;
import ai.fxn.fxn.gradle.PredictionCache;
import ai.fxn.fxn.gradle.PredictionResource;
import com.android.build.gradle.AppExtension;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0017H\u0002J\b\u0010\"\u001a\u00020\u0015H\u0007J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0$2\u0006\u0010%\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006&"}, d2={"Lai/fxn/fxn/gradle/EmbedPredictorsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "androidExtension", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/AppExtension;", "getAndroidExtension", "()Lorg/gradle/api/provider/Property;", "assetDir", "Lorg/gradle/api/file/DirectoryProperty;", "getAssetDir", "()Lorg/gradle/api/file/DirectoryProperty;", "extension", "Lai/fxn/fxn/gradle/FunctionExtension;", "getExtension", "libDir", "getLibDir", "moshi", "Lcom/squareup/moshi/Moshi;", "getMoshi", "cleanDirectory", "", "dir", "Ljava/io/File;", "createPrediction", "Lai/fxn/fxn/gradle/Prediction;", "tag", "", "clientId", "apiUrl", "accessKey", "downloadResource", "url", "destination", "embed", "getAbis", "", "android", "fxn-gradle"})
@SourceDebugExtension(value={"SMAP\nEmbedPredictorsTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbedPredictorsTask.kt\nai/fxn/fxn/gradle/EmbedPredictorsTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1855#2:173\n1855#2:174\n1855#2,2:175\n1856#2:177\n1856#2:178\n*S KotlinDebug\n*F\n+ 1 EmbedPredictorsTask.kt\nai/fxn/fxn/gradle/EmbedPredictorsTask\n*L\n56#1:173\n57#1:174\n66#1:175,2\n57#1:177\n56#1:178\n*E\n"})
public abstract class EmbedPredictorsTask
extends DefaultTask {
    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getAssetDir();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getLibDir();

    @Internal
    @NotNull
    public abstract Property<FunctionExtension> getExtension();

    @Internal
    @NotNull
    public abstract Property<Moshi> getMoshi();

    @Internal
    @NotNull
    public abstract Property<AppExtension> getAndroidExtension();

    @TaskAction
    public final void embed() {
        String string;
        String accessKey;
        Directory assetDir = (Directory)this.getAssetDir().get();
        Directory libDir = (Directory)this.getLibDir().get();
        FunctionExtension ext = (FunctionExtension)this.getExtension().get();
        List embeds = (List)ext.getEmbeds().get();
        Object object = this.getAndroidExtension().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        List<String> abis = this.getAbis((AppExtension)object);
        String string2 = (String)ext.getAccessKey().getOrNull();
        if (string2 == null) {
            string2 = accessKey = "";
        }
        if ((string = (String)ext.getApiUrl().getOrNull()) == null) {
            string = "https://api.fxn.ai/v1";
        }
        String apiUrl = string;
        List predictions = new ArrayList();
        File file = assetDir.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        this.cleanDirectory(file);
        File file2 = libDir.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAsFile(...)");
        this.cleanDirectory(file2);
        Intrinsics.checkNotNull((Object)embeds);
        Iterable $this$forEach$iv = embeds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FunctionEmbed embed = (FunctionEmbed)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = abis;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String string3;
                String abi = (String)element$iv2;
                boolean bl2 = false;
                Directory abiDir = libDir.dir(abi);
                String string4 = embed.getTag();
                String string5 = "android-" + abi;
                String string6 = embed.getApiUrl();
                if (string6 == null) {
                    string6 = apiUrl;
                }
                if ((string3 = embed.getAccessKey()) == null) {
                    string3 = accessKey;
                }
                Object object2 = this.getMoshi().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                Prediction prediction = this.createPrediction(string4, string5, string6, string3, (Moshi)object2);
                Iterable $this$forEach$iv3 = prediction.getResources();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    PredictionResource resource = (PredictionResource)element$iv3;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)resource.getType(), (Object)"dso")) continue;
                    String string7 = new URL(resource.getUrl()).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getPath(...)");
                    String hash = StringsKt.substringAfterLast$default((String)string7, (String)"/", null, (int)2, null);
                    Object object3 = resource.getName();
                    if (object3 == null) {
                        object3 = hash + ".so";
                    }
                    String name = object3;
                    String string8 = resource.getUrl();
                    File file3 = abiDir.file(name).getAsFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAsFile(...)");
                    this.downloadResource(string8, file3);
                }
                prediction.setClientId(abi);
                predictions.add(prediction);
            }
        }
        PredictionCache cache = new PredictionCache(predictions);
        JsonAdapter cacheAdapter = ((Moshi)this.getMoshi().get()).adapter(PredictionCache.class).indent("  ");
        String cacheJson = cacheAdapter.toJson((Object)cache);
        RegularFile cacheFile = assetDir.file("fxn.resolved");
        File file4 = cacheFile.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getAsFile(...)");
        Intrinsics.checkNotNull((Object)cacheJson);
        FilesKt.writeText$default((File)file4, (String)cacheJson, null, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Prediction createPrediction(String tag, String clientId, String apiUrl, String accessKey, Moshi moshi) {
        OkHttpClient client = new OkHttpClient();
        JsonAdapter jsonAdapter = moshi.adapter(CreatePredictionInput.class);
        JsonAdapter responseAdapter = moshi.adapter(Prediction.class);
        JsonAdapter errorAdapter = moshi.adapter(ErrorResponse.class);
        CreatePredictionInput requestBody = new CreatePredictionInput(tag, clientId);
        String requestBodyJson = jsonAdapter.toJson((Object)requestBody);
        MediaType mediaType = MediaType.Companion.get("application/json; charset=utf-8");
        Intrinsics.checkNotNull((Object)requestBodyJson);
        RequestBody body = RequestBody.Companion.create(mediaType, requestBodyJson);
        Request request = new Request.Builder().url(apiUrl + "/predictions").addHeader("Authorization", "Bearer " + accessKey).post(body).build();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            Response response = (Response)closeable;
            boolean bl = false;
            Object object = response.body();
            if (object == null || (object = object.string()) == null) {
                throw new Exception("Function failed to embed `" + tag + "` predictor with status code: " + response.code());
            }
            Object responseBody = object;
            if (response.isSuccessful()) {
                Object object2 = responseAdapter.fromJson((String)responseBody);
                Intrinsics.checkNotNull((Object)object2);
                Prediction prediction = (Prediction)object2;
                return prediction;
            }
            try {
                ErrorResponseItem[] errors = (ErrorResponseItem[])errorAdapter.fromJson((String)responseBody);
                Object object3 = errors;
                if (errors == null || (object3 = ((ErrorResponse)object3).getErrors()) == null || (object3 = object3[0]) == null || (object3 = ((ErrorResponseItem)object3).getMessage()) == null) {
                    object3 = "unknown error";
                }
                Object error = object3;
                throw new Exception("Function failed to embed `" + tag + "` predictor with error: " + (String)error);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadResource(String url, File destination) {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).build();
        destination.getParentFile().mkdirs();
        Closeable closeable = (Closeable)client.newCall(request).execute();
        Throwable throwable = null;
        try {
            long l;
            Response response = (Response)closeable;
            boolean bl = false;
            if (!response.isSuccessful()) {
                throw new Exception("Function failed to download prediction resource from " + url + ": " + response);
            }
            Object object = response.body();
            if (object != null && (object = object.byteStream()) != null) {
                Closeable closeable2 = (Closeable)object;
                Throwable throwable2 = null;
                try {
                    long l2;
                    InputStream input = (InputStream)closeable2;
                    boolean bl2 = false;
                    Closeable closeable3 = new FileOutputStream(destination);
                    Throwable throwable3 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)closeable3;
                        boolean bl3 = false;
                        l2 = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                    }
                    l = l2;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            throw new Exception("Empty response body when downloading " + url);
            long l3 = l;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final List<String> getAbis(AppExtension android) {
        Object[] objectArray = new String[]{"armeabi-v7a", "arm64-v8a", "x86_64"};
        List DEFAULT_ABIS = CollectionsKt.listOf((Object[])objectArray);
        Set set = android.getDefaultConfig().getNdk().getAbiFilters();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-abiFilters>(...)");
        Set abiFilters = set;
        return !((Collection)abiFilters).isEmpty() ? CollectionsKt.toList((Iterable)abiFilters) : DEFAULT_ABIS;
    }

    private final void cleanDirectory(File dir) {
        if (dir.exists()) {
            FilesKt.deleteRecursively((File)dir);
        }
        dir.mkdirs();
    }
}

