/*
 * Decompiled with CFR 0.152.
 */
package glair.vision;

import glair.vision.api.Config;
import glair.vision.api.FaceBio;
import glair.vision.api.Identity;
import glair.vision.api.Ocr;
import glair.vision.logger.Logger;
import glair.vision.logger.LoggerConfig;
import glair.vision.model.VisionSettings;

public class Vision {
    public static final String version = "0.0.1-beta.1";
    private static final Logger logger = Logger.getInstance();
    private final Config config;
    private final Ocr ocr;
    private final FaceBio faceBio;
    private final Identity identity;

    public Vision(VisionSettings visionSettings) {
        this(visionSettings, new LoggerConfig());
    }

    public Vision(VisionSettings visionSettings, LoggerConfig loggerConfig) {
        this.config = new Config(visionSettings);
        this.ocr = new Ocr(this.config);
        this.faceBio = new FaceBio(this.config);
        this.identity = new Identity(this.config);
        if (loggerConfig != null) {
            logger.setPattern(loggerConfig.getLogPattern());
            logger.setLogLevel(loggerConfig.getLogLevel());
        }
    }

    public Config config() {
        return this.config;
    }

    public Ocr ocr() {
        return this.ocr;
    }

    public FaceBio faceBio() {
        return this.faceBio;
    }

    public Identity identity() {
        return this.identity;
    }

    public void printLoggerConfig() {
        System.out.println("Logger Config " + logger);
    }
}

