/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.api;

import glair.vision.model.VisionSettings;
import glair.vision.util.Json;
import java.util.HashMap;
import okhttp3.Credentials;

public class Config {
    private static final String BASE_URL = "https://api.vision.glair.ai";
    private static final String API_VERSION = "v1";
    private static final String API_KEY = "default-api-key";
    private static final String USERNAME = "default-username";
    private static final String PASSWORD = "default-password";
    private final String baseUrl;
    private final String apiVersion;
    private final String apiKey;
    private final String username;
    private final String password;
    private final VisionSettings visionSettings;
    private String basicAuth;

    public Config(VisionSettings config) {
        this.baseUrl = config.getBaseUrl() == null ? BASE_URL : config.getBaseUrl();
        this.apiVersion = config.getApiVersion() == null ? API_VERSION : config.getApiVersion();
        this.apiKey = config.getApiKey() == null ? API_KEY : config.getApiKey();
        this.username = config.getUsername() == null ? USERNAME : config.getUsername();
        this.password = config.getPassword() == null ? PASSWORD : config.getPassword();
        this.visionSettings = config;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getUrl(String path) {
        return this.baseUrl + "/" + this.replaceVersion(path);
    }

    public String getBasicAuth() {
        if (this.basicAuth == null) {
            String auth;
            this.basicAuth = auth = Credentials.basic((String)this.username, (String)this.password);
            return auth;
        }
        return this.basicAuth;
    }

    public Config getConfig() {
        return this;
    }

    public Config getConfig(VisionSettings newConfig) {
        String baseUrl = newConfig.getBaseUrl() == null ? this.baseUrl : newConfig.getBaseUrl();
        String apiVersion = newConfig.getApiVersion() == null ? this.apiVersion : newConfig.getApiVersion();
        String apiKey = newConfig.getApiKey() == null ? this.apiKey : newConfig.getApiKey();
        String username = newConfig.getUsername() == null ? this.username : newConfig.getUsername();
        String password = newConfig.getPassword() == null ? this.password : newConfig.getPassword();
        VisionSettings visionSettings = new VisionSettings.Builder().baseUrl(baseUrl).apiVersion(apiVersion).apiKey(apiKey).username(username).password(password).build();
        return new Config(visionSettings);
    }

    public VisionSettings getSettings() {
        return this.visionSettings;
    }

    private String replaceVersion(String path) {
        return path.replaceAll(":version", this.apiVersion);
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("baseUrl", this.baseUrl);
        map.put("apiVersion", this.apiVersion);
        map.put("apiKey", this.apiKey);
        map.put("username", this.username);
        map.put("password", this.password);
        return "Config " + Json.toJsonString(map, 2);
    }
}

