/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.api;

import glair.vision.api.Config;
import glair.vision.api.sessions.ActiveLivenessSessions;
import glair.vision.api.sessions.PassiveLivenessSessions;
import glair.vision.logger.Logger;
import glair.vision.model.Request;
import glair.vision.model.VisionSettings;
import glair.vision.model.param.ActiveLivenessParam;
import glair.vision.model.param.FaceMatchParam;
import glair.vision.util.Json;
import glair.vision.util.Util;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class FaceBio {
    private static final Logger logger = Logger.getInstance();
    private final Config config;
    private final ActiveLivenessSessions activeLivenessSessions;
    private final PassiveLivenessSessions passiveLivenessSessions;

    public FaceBio(Config config) {
        this.config = config;
        this.activeLivenessSessions = new ActiveLivenessSessions(config);
        this.passiveLivenessSessions = new PassiveLivenessSessions(config);
    }

    public ActiveLivenessSessions activeLivenessSessions() {
        return this.activeLivenessSessions;
    }

    public PassiveLivenessSessions passiveLivenessSessions() {
        return this.passiveLivenessSessions;
    }

    public String match(FaceMatchParam param) throws Exception {
        return this.match(param, null);
    }

    public String match(FaceMatchParam param, VisionSettings newVisionSettings) throws Exception {
        this.log("Match", param);
        Util.checkFileExist(param.getCapturedPath());
        Util.checkFileExist(param.getStoredPath());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("captured_image", Util.fileToBase64(param.getCapturedPath()));
        map.put("stored_image", Util.fileToBase64(param.getStoredPath()));
        RequestBody body = RequestBody.create((String)Json.toJsonString(map), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        return this.fetch(body, "match", newVisionSettings);
    }

    public String passiveLiveness(String imagePath) throws Exception {
        return this.passiveLiveness(imagePath, null);
    }

    public String passiveLiveness(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.log("Passive Liveness", Json.toJsonString("image", imagePath));
        Util.checkFileExist(imagePath);
        MultipartBody.Builder builder = Util.createFormData();
        Util.addFileToFormData(builder, "image", imagePath);
        return this.fetch((RequestBody)builder.build(), "passive-liveness", newVisionSettings);
    }

    public String activeLiveness(ActiveLivenessParam param) throws Exception {
        return this.activeLiveness(param, null);
    }

    public String activeLiveness(ActiveLivenessParam param, VisionSettings newVisionSettings) throws Exception {
        this.log("Active Liveness", param);
        Util.checkFileExist(param.getImagePath());
        MultipartBody.Builder builder = Util.createFormData();
        Util.addFileToFormData(builder, "image", param.getImagePath());
        Util.addTextToFormData(builder, "gesture-code", param.getGestureCode().label);
        return this.fetch((RequestBody)builder.build(), "active-liveness", newVisionSettings);
    }

    private String fetch(RequestBody body, String url, VisionSettings newVisionSettings) throws Exception {
        VisionSettings settingsToUse = newVisionSettings == null ? this.config.getSettings() : newVisionSettings;
        String method = "POST";
        String endpoint = "face/:version/" + url;
        Request request = new Request.RequestBuilder(endpoint, method).body(body).build();
        return Util.visionFetch(this.config.getConfig(settingsToUse), request);
    }

    private void log(String logTitle, Object param) {
        logger.info("Face Biometric -", logTitle);
        logger.debug("Param", param);
    }
}

