/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.api;

import glair.vision.api.Config;
import glair.vision.logger.Logger;
import glair.vision.model.Request;
import glair.vision.model.VisionSettings;
import glair.vision.model.param.IdentityFaceVerificationParam;
import glair.vision.model.param.IdentityVerificationParam;
import glair.vision.util.Util;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Identity {
    private static final Logger logger = Logger.getInstance();
    private final Config config;

    public Identity(Config config) {
        this.config = config;
    }

    public String verification(IdentityVerificationParam param) throws Exception {
        return this.verification(param, null);
    }

    public String verification(IdentityVerificationParam param, VisionSettings newVisionSettings) throws Exception {
        this.log("Basic Verification", param);
        MultipartBody.Builder bodyBuilder = Util.createFormData();
        Util.addTextToFormData(bodyBuilder, "nik", param.getNik());
        Util.addTextToFormData(bodyBuilder, "name", param.getName());
        Util.addTextToFormData(bodyBuilder, "date_of_birth", param.getDateOfBirth());
        return this.fetch(bodyBuilder, newVisionSettings, "verification");
    }

    public String faceVerification(IdentityFaceVerificationParam param) throws Exception {
        return this.faceVerification(param, null);
    }

    public String faceVerification(IdentityFaceVerificationParam param, VisionSettings newVisionSettings) throws Exception {
        this.log("Face Verification", param);
        Util.checkFileExist(param.getFaceImagePath());
        MultipartBody.Builder bodyBuilder = Util.createFormData();
        Util.addTextToFormData(bodyBuilder, "nik", param.getNik());
        Util.addTextToFormData(bodyBuilder, "name", param.getName());
        Util.addTextToFormData(bodyBuilder, "date_of_birth", param.getDateOfBirth());
        Util.addFileToFormData(bodyBuilder, "face_image", param.getFaceImagePath());
        return this.fetch(bodyBuilder, newVisionSettings, "face-verification");
    }

    private String fetch(MultipartBody.Builder bodyBuilder, VisionSettings newVisionSettings, String endpoint) throws Exception {
        VisionSettings settingsToUse = newVisionSettings == null ? this.config.getSettings() : newVisionSettings;
        String url = "identity/:version/" + endpoint;
        String method = "POST";
        MultipartBody body = bodyBuilder.build();
        Request request = new Request.RequestBuilder(url, method).body((RequestBody)body).build();
        return Util.visionFetch(this.config.getConfig(settingsToUse), request);
    }

    private void log(String logTitle, Object param) {
        logger.info("Identity -", logTitle);
        logger.debug("Param", param);
    }
}

