/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.api;

import glair.vision.api.Config;
import glair.vision.api.sessions.KtpSessions;
import glair.vision.api.sessions.NpwpSessions;
import glair.vision.logger.Logger;
import glair.vision.model.Request;
import glair.vision.model.VisionSettings;
import glair.vision.model.param.BpkbParam;
import glair.vision.model.param.KtpParam;
import glair.vision.util.Json;
import glair.vision.util.Util;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Ocr {
    private static final Logger logger = Logger.getInstance();
    private final Config config;
    private final KtpSessions ktpSessions;
    private final NpwpSessions npwpSessions;

    public Ocr(Config config) {
        this.config = config;
        this.ktpSessions = new KtpSessions(config);
        this.npwpSessions = new NpwpSessions(config);
    }

    public KtpSessions ktpSessions() {
        return this.ktpSessions;
    }

    public NpwpSessions npwpSessions() {
        return this.npwpSessions;
    }

    public String ktp(KtpParam param) throws Exception {
        return this.ktp(param, null);
    }

    public String ktp(KtpParam param, VisionSettings newVisionSettings) throws Exception {
        this.log("KTP", param);
        Util.checkFileExist(param.getImagePath());
        String endpoint = param.getQualitiesDetector() != false ? "ktp/qualities" : "ktp";
        MultipartBody.Builder bodyBuilder = Util.createFormData();
        Util.addFileToFormData(bodyBuilder, "image", param.getImagePath());
        return this.fetch(bodyBuilder, newVisionSettings, endpoint);
    }

    public String npwp(String imagePath) throws Exception {
        return this.npwp(imagePath, null);
    }

    public String npwp(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("NPWP", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "npwp");
    }

    public String kk(String imagePath) throws Exception {
        return this.kk(imagePath, null);
    }

    public String kk(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("KK", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "kk");
    }

    public String stnk(String imagePath) throws Exception {
        return this.stnk(imagePath, null);
    }

    public String stnk(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("STNK", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "stnk");
    }

    public String bpkb(BpkbParam param) throws Exception {
        return this.bpkb(param, null);
    }

    public String bpkb(BpkbParam param, VisionSettings newVisionSettings) throws Exception {
        this.log("BPKB", param);
        Util.checkFileExist(param.getImagePath());
        MultipartBody.Builder bodyBuilder = Util.createFormData();
        Util.addFileToFormData(bodyBuilder, "image", param.getImagePath());
        if (param.getPage() >= 1 && param.getPage() <= 4) {
            Util.addTextToFormData(bodyBuilder, "page", Integer.toString(param.getPage()));
        }
        return this.fetch(bodyBuilder, newVisionSettings, "bpkb");
    }

    public String passport(String imagePath) throws Exception {
        return this.passport(imagePath, null);
    }

    public String passport(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("Passport", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "passport");
    }

    public String licensePlate(String imagePath) throws Exception {
        return this.licensePlate(imagePath, null);
    }

    public String licensePlate(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("License Plate", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "plate");
    }

    public String generalDocument(String imagePath) throws Exception {
        return this.generalDocument(imagePath, null);
    }

    public String generalDocument(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("General Document", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "general-document");
    }

    public String invoice(String imagePath) throws Exception {
        return this.invoice(imagePath, null);
    }

    public String invoice(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("Invoice", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "invoice");
    }

    public String receipt(String imagePath) throws Exception {
        return this.receipt(imagePath, null);
    }

    public String receipt(String imagePath, VisionSettings newVisionSettings) throws Exception {
        this.logSingle("Receipt", imagePath);
        return this.fetchSingle(imagePath, newVisionSettings, "receipt");
    }

    private String fetchSingle(String imagePath, VisionSettings newVisionSettings, String endpoint) throws Exception {
        Util.checkFileExist(imagePath);
        MultipartBody.Builder bodyBuilder = Util.createFormData();
        Util.addFileToFormData(bodyBuilder, "image", imagePath);
        return this.fetch(bodyBuilder, newVisionSettings, endpoint);
    }

    private String fetch(MultipartBody.Builder bodyBuilder, VisionSettings newVisionSettings, String endpoint) throws Exception {
        VisionSettings settingsToUse = newVisionSettings == null ? this.config.getSettings() : newVisionSettings;
        String url = "ocr/:version/" + endpoint;
        String method = "POST";
        MultipartBody body = bodyBuilder.build();
        Request request = new Request.RequestBuilder(url, method).body((RequestBody)body).build();
        return Util.visionFetch(this.config.getConfig(settingsToUse), request);
    }

    private void logSingle(String logTitle, String imagePath) {
        this.log(logTitle, Json.toJsonString("image", imagePath));
    }

    private void log(String logTitle, Object param) {
        logger.info("OCR -", logTitle);
        logger.debug("Param", param);
    }
}

