/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.logger;

import glair.vision.util.Json;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Logger {
    private static Logger instance;
    private final String[] logLevelMapping = new String[]{"debug", "info ", "warn ", "error"};
    private int logLevel;
    private String pattern;

    private Logger() {
    }

    public static synchronized Logger getInstance() {
        if (instance == null) {
            instance = new Logger();
        }
        return instance;
    }

    public String getLogLevel() {
        return this.logLevelMapping[this.logLevel].toUpperCase();
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void debug(Object ... args) {
        this.log(0, args);
    }

    public void info(Object ... args) {
        this.log(1, args);
    }

    public void warn(Object ... args) {
        this.log(2, args);
    }

    public void error(Object ... args) {
        this.log(3, args);
    }

    private void log(int logLevel, Object ... args) {
        if (logLevel < this.logLevel) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        String now = dateFormat.format(new Date());
        String level = this.logLevelMapping[logLevel];
        StringBuilder messageBuilder = new StringBuilder();
        for (Object arg : args) {
            messageBuilder.append(this.stringify(arg)).append(" ");
        }
        String message = messageBuilder.toString().trim();
        String formattedLog = this.pattern.replace("{timestamp}", now).replace("{level}", level.toUpperCase()).replace("{message}", message);
        System.out.println(formattedLog);
    }

    private String stringify(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            return obj.toString();
        }
        catch (Exception e) {
            return "Failed to convert to JSON: " + obj;
        }
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Log Level", this.getLogLevel());
        map.put("Log Pattern", this.getPattern());
        return Json.toJsonString(map, 2);
    }

    public static void main(String[] args) {
        Logger logger = new Logger();
        logger.info("This is an info message.", 42, true);
        logger.debug("This is a debug message.", new int[]{1, 2, 3});
    }
}

